/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.ngp;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.CallbackRequest;
import org.eclipse.scada.core.data.CallbackResponse;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.RequestMessage;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.core.data.message.CreateSession;
import org.eclipse.scada.core.data.message.RequestCallbacks;
import org.eclipse.scada.core.data.message.RespondCallbacks;
import org.eclipse.scada.core.data.message.SessionAccepted;
import org.eclipse.scada.core.data.message.SessionPrivilegesChanged;
import org.eclipse.scada.core.data.message.SessionRejected;
import org.eclipse.scada.core.ngp.MessageSender;
import org.eclipse.scada.core.ngp.ResponseManager;
import org.eclipse.scada.core.server.Service;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.core.server.ngp.ServerConnection;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;
import org.eclipse.scada.utils.concurrent.CallingFuture;
import org.eclipse.scada.utils.concurrent.DirectExecutor;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceServerConnection<T extends Session, S extends Service<T>>
extends ServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(ServiceServerConnection.class);
    protected final S service;
    protected T session;
    private boolean enablePrivs;
    private boolean logonInProgress;
    private boolean enableCallbacks;
    private final ResponseManager responseManager;
    private final MessageSender messageSender = new MessageSender(){

        public void sendMessage(Object message) {
            ServiceServerConnection.this.sendMessage(message);
        }
    };
    private final IoSession ioSession;

    public ServiceServerConnection(IoSession session, S service) {
        super(session);
        this.ioSession = session;
        this.service = service;
        this.responseManager = new ResponseManager(this.statistics, this.messageSender, DirectExecutor.INSTANCE);
        this.responseManager.connected();
    }

    @Override
    public void messageReceived(Object message) throws Exception {
        logger.trace("Received message : {}", message);
        if (message instanceof CreateSession) {
            this.handleCreateSession((CreateSession)message);
        } else if (message instanceof ResponseMessage) {
            this.responseManager.handleResponse((ResponseMessage)message);
        }
    }

    protected synchronized void handleCreateSession(CreateSession message) {
        if (this.logonInProgress) {
            logger.warn("Logon already in progress");
            return;
        }
        try {
            this.enablePrivs = message.getProperties().containsKey("feature.core.session.privileges");
            logger.info("Enable privileges: {}", (Object)this.enablePrivs);
            this.enableCallbacks = message.getProperties().containsKey("feature.core.callbacks");
            logger.info("Enable callbacks: {}", (Object)this.enableCallbacks);
            this.logonInProgress = true;
            CallbackHandler callbackHandler = this.createCallbackHandlerFromMessage(message);
            HashMap<String, Object> contextInformation = new HashMap<String, Object>(1);
            contextInformation.put("remoteAddress", this.ioSession.getRemoteAddress());
            NotifyFuture<T> future = this.performCreateSession(message.getProperties(), contextInformation, callbackHandler);
            future.addListener(new FutureListener<T>(){

                public void complete(Future<T> future) {
                    try {
                        ServiceServerConnection.this.setSession(future);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to set session", (Throwable)e);
                        ServiceServerConnection.this.failSession(e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to create session", (Throwable)e);
            this.failSession(e);
        }
    }

    private CallbackHandler createCallbackHandlerFromMessage(CreateSession message) {
        if (message.getProperties().containsKey("user") && message.getProperties().containsKey("password")) {
            logger.info("Using properties based callback handler since 'username' and 'password' are provided");
            return new PropertiesCredentialsCallback(message.getProperties());
        }
        return this.createCallbackHandler(message.getCallbackHandlerId());
    }

    protected synchronized void failSession(Exception e) {
        this.logonInProgress = false;
        this.sendMessage(this.makeRejectMessage(e));
        this.requestClose(false);
    }

    protected synchronized void setSession(Future<T> sessionFuture) throws Exception {
        this.logonInProgress = false;
        this.session = (Session)sessionFuture.get();
        this.initializeSession(this.session);
        this.sendMessage(this.makeSuccessMessage(this.session.getProperties()));
        this.session.addSessionListener(new Session.SessionListener(){

            public void privilegeChange() {
                ServiceServerConnection.this.handlePrivilegeChange();
            }
        });
    }

    protected void initializeSession(T session) {
    }

    protected SessionPrivilegesChanged makePrivilegeChangeMessage(Set<String> privileges) {
        return new SessionPrivilegesChanged(privileges);
    }

    private SessionAccepted makeSuccessMessage(Map<String, String> properties) {
        return new SessionAccepted(properties);
    }

    private SessionRejected makeRejectMessage(Exception e) {
        return new SessionRejected(e.getMessage());
    }

    private NotifyFuture<T> performCreateSession(Map<String, String> properties, Map<String, Object> contextInformation, CallbackHandler callbackHandler) {
        if (this.session != null) {
            throw new IllegalStateException("A session was already created");
        }
        Properties p = new Properties();
        p.putAll(properties);
        return this.createSession(p, contextInformation, callbackHandler);
    }

    protected NotifyFuture<T> createSession(Properties properties, Map<String, Object> contextInformation, CallbackHandler callbackHandler) {
        return this.service.createSession(properties, contextInformation, callbackHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        T session;
        ServiceServerConnection serviceServerConnection = this;
        synchronized (serviceServerConnection) {
            session = this.session;
            this.session = null;
        }
        this.responseManager.disconnected();
        if (session != null) {
            try {
                this.service.closeSession(session);
            }
            catch (InvalidSessionException e) {
                logger.warn("Failed to close session", (Throwable)e);
            }
        }
        super.dispose();
    }

    private void handlePrivilegeChange() {
        if (this.enablePrivs) {
            this.sendMessage(this.makePrivilegeChangeMessage(this.session.getPrivileges()));
        }
    }

    protected CallbackHandler createCallbackHandler(final Long callbackHandlerId) {
        if (callbackHandlerId == null) {
            return null;
        }
        return new CallbackHandler(){

            public NotifyFuture<Callback[]> performCallback(Callback[] callbacks) {
                return ServiceServerConnection.this.performCallbacks(callbackHandlerId, callbacks);
            }
        };
    }

    private synchronized NotifyFuture<Callback[]> performCallbacks(long callbackHandlerId, final Callback[] callbacks) {
        if (!this.enableCallbacks) {
            return Callbacks.cancelAll((Callback[])callbacks);
        }
        NotifyFuture future = this.responseManager.sendRequestMessage(this.makeCallbackMessage(callbackHandlerId, callbacks));
        return new CallingFuture<ResponseMessage, Callback[]>(future){

            public Callback[] call(Future<ResponseMessage> future) throws Exception {
                ServiceServerConnection.this.parseCallbackResponse((RespondCallbacks)future.get(), callbacks);
                return callbacks;
            }
        };
    }

    private void parseCallbackResponse(RespondCallbacks response, Callback[] callbacks) {
        ErrorInformation error = response.getErrorInformation();
        if (error == null && response.getCallbacks().size() == callbacks.length) {
            int i = 0;
            for (CallbackResponse cr : response.getCallbacks()) {
                if (cr.isCanceled()) {
                    callbacks[i].cancel();
                } else {
                    callbacks[i].parseResponseAttributes(cr.getAttributes());
                }
                ++i;
            }
        } else {
            if (error != null) {
                throw new RuntimeException(error.getMessage());
            }
            throw new RuntimeException("Unknown error");
        }
    }

    private RequestMessage makeCallbackMessage(long callbackHandlerId, Callback[] callbacks) {
        LinkedList<CallbackRequest> requests = new LinkedList<CallbackRequest>();
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback cb = callbackArray[n2];
            requests.add(new CallbackRequest(cb.getType(), cb.buildRequestAttributes()));
            ++n2;
        }
        return new RequestCallbacks(this.responseManager.nextRequest(), callbackHandlerId, requests, Long.valueOf(Callback.DEFAULT_TIMEOUT));
    }
}

