/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.net.handler;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.ListValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.utils.lang.Holder;

public class Messages
extends MessageHelper {
    public static final int CC_SUBSCRIBE_ITEM = 65552;
    public static final int CC_UNSUBSCRIBE_ITEM = 65553;
    public static final int CC_NOTIFY_DATA = 65568;
    public static final int CC_SUBSCRIPTION_CHANGE = 65570;
    public static final int CC_WRITE_OPERATION = 65584;
    public static final int CC_WRITE_OPERATION_RESULT = 65585;
    public static final int CC_READ_OPERATION = 65600;
    public static final int CC_WRITE_ATTRIBUTES_OPERATION = 65616;
    public static final int CC_WRITE_ATTRIBUTES_OPERATION_RESULT = 65600;
    public static final int CC_BROWSER_LIST_REQ = 66048;
    public static final int CC_BROWSER_LIST_RES = 66049;
    public static final int CC_BROWSER_EVENT = 66064;
    public static final int CC_BROWSER_SUBSCRIBE = 66065;
    public static final int CC_BROWSER_UNSUBSCRIBE = 66066;

    public static Message subscribeItem(String itemName) {
        Message msg = new Message(65552);
        msg.getValues().put("item-id", (Value)new StringValue(itemName));
        return msg;
    }

    public static Message unsubscribeItem(String itemName) {
        Message msg = new Message(65553);
        msg.getValues().put("item-id", (Value)new StringValue(itemName));
        return msg;
    }

    public static Message notifyData(String itemName, Variant value, Map<String, Variant> attributes, boolean cache) {
        Value messageValue;
        Message msg = new Message(65568);
        msg.getValues().put("item-id", (Value)new StringValue(itemName));
        if (cache) {
            msg.getValues().put("cache-read", (Value)VoidValue.INSTANCE);
        }
        if ((messageValue = Messages.variantToValue((Variant)value)) != null) {
            msg.getValues().put("value", messageValue);
        }
        ListValue unsetEntries = new ListValue();
        MapValue setEntries = new MapValue();
        if (attributes != null) {
            for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
                Value valueEntry = Messages.variantToValue((Variant)entry.getValue());
                if (valueEntry == null) {
                    unsetEntries.add((Value)new StringValue(entry.getKey()));
                    continue;
                }
                setEntries.put(entry.getKey(), valueEntry);
            }
        }
        msg.getValues().put("attributes-unset", (Value)unsetEntries);
        msg.getValues().put("attributes-set", (Value)setEntries);
        return msg;
    }

    public static int encodeIO(Set<IODirection> io) {
        int bits = 0;
        if (io.contains(IODirection.INPUT)) {
            bits |= 1;
        }
        if (io.contains(IODirection.OUTPUT)) {
            bits |= 2;
        }
        return bits;
    }

    public static Set<IODirection> decodeIO(int bits) {
        EnumSet<IODirection> ioDirection = EnumSet.noneOf(IODirection.class);
        if ((bits & 1) > 0) {
            ioDirection.add(IODirection.INPUT);
        }
        if ((bits & 2) > 0) {
            ioDirection.add(IODirection.OUTPUT);
        }
        return ioDirection;
    }

    public static Message notifySubscriptionChange(String item, SubscriptionState subscriptionState) {
        Message msg = new Message(65570);
        msg.getValues().put("item-id", (Value)new StringValue(item));
        switch (subscriptionState) {
            case DISCONNECTED: {
                msg.getValues().put("state", (Value)IntegerValue.valueOf((int)0));
                break;
            }
            case GRANTED: {
                msg.getValues().put("state", (Value)IntegerValue.valueOf((int)1));
                break;
            }
            case CONNECTED: {
                msg.getValues().put("state", (Value)IntegerValue.valueOf((int)2));
            }
        }
        return msg;
    }

    public static void parseSubscriptionChange(Message msg, Holder<String> item, Holder<SubscriptionState> subscriptionState) {
        if (msg.getValues().containsKey("item-id")) {
            item.value = msg.getValues().get("item-id").toString();
        }
        if (msg.getValues().containsKey("state") && msg.getValues().get("state") instanceof IntegerValue) {
            switch (((IntegerValue)msg.getValues().get("state")).getValue()) {
                case 0: {
                    subscriptionState.value = SubscriptionState.DISCONNECTED;
                    break;
                }
                case 1: {
                    subscriptionState.value = SubscriptionState.GRANTED;
                    break;
                }
                case 2: {
                    subscriptionState.value = SubscriptionState.CONNECTED;
                }
            }
        }
    }
}

