/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.eclipse.scada.base.extractor.extract.Extractor;
import org.eclipse.scada.base.extractor.extract.ItemDescriptor;
import org.eclipse.scada.base.extractor.extract.ItemValue;
import org.eclipse.scada.base.extractor.input.Data;
import org.eclipse.scada.base.extractor.input.Input;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.IDNameProvider;
import org.eclipse.scada.da.server.browser.common.query.InvisibleStorage;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.PatternNameProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitGroupProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitNameProvider;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.component.Component;
import org.eclipse.scada.da.server.component.ComponentHost;
import org.eclipse.scada.da.server.component.ComponentItemFactory;
import org.eclipse.scada.da.server.component.Hive;
import org.eclipse.scada.utils.ExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParserComponent
extends Component {
    private static final Logger logger = LoggerFactory.getLogger(ParserComponent.class);
    private final Set<Input> inputs = new HashSet<Input>();
    private final String prefix;
    private final Hive hive;
    private final InvisibleStorage storage;
    private final GroupFolder groupFolder;
    private final Map<Extractor, Map<String, DataItemInputChained>> itemCache = new HashMap<Extractor, Map<String, DataItemInputChained>>();
    private ComponentItemFactory itemFactory;
    private Variant lastError;

    public ParserComponent(Executor executor, Hive hive, FolderCommon folder, String activationPrefix) {
        super(executor, (ComponentHost)hive, activationPrefix);
        this.hive = hive;
        this.prefix = activationPrefix;
        this.storage = new InvisibleStorage();
        Pattern pattern = Pattern.compile(String.valueOf(Pattern.quote(String.valueOf(this.prefix) + ".")) + "(.*)");
        PatternNameProvider nameProvider = new PatternNameProvider((NameProvider)new IDNameProvider(), pattern, 1);
        SplitGroupProvider groupProvider = new SplitGroupProvider((NameProvider)nameProvider, "\\.", 0, 1);
        this.groupFolder = new GroupFolder((GroupProvider)groupProvider, (NameProvider)new SplitNameProvider((NameProvider)new IDNameProvider(), "\\.", 0, 1, "."), folder);
        this.storage.addChild((ItemStorage)this.groupFolder);
    }

    protected void bindInput(Input input, final Extractor extractor, final String prefix) {
        this.inputs.add(input);
        input.addInputListener(new Input.Listener(){

            public void processInput(Data data) {
                ParserComponent.this.processResult(extractor, extractor.processData(data), prefix);
            }
        });
    }

    protected synchronized void processResult(Extractor extractor, Extractor.Result result, String prefix) {
        logger.trace("Process result: {} from: {} ({})", new Object[]{result, extractor, prefix});
        try {
            if (result.getError() != null) {
                this.setError(extractor, prefix, result.getError() != null ? result.getError() : new IllegalStateException("No data"), result.getItemValues());
            } else {
                this.setValues(extractor, prefix, result.getItemValues() != null ? result.getItemValues() : Collections.emptyMap());
            }
        }
        catch (Exception e) {
            logger.warn("Failed process result", (Throwable)e);
        }
    }

    private void setError(Extractor extractor, String prefix, Throwable throwable, Map<ItemDescriptor, ItemValue> items) {
        Map<String, DataItemInputChained> cache;
        if (this.lastError == null) {
            this.lastError = Variant.valueOf((long)System.currentTimeMillis());
        }
        if ((cache = this.itemCache.get(extractor)) == null) {
            cache = new HashMap<String, DataItemInputChained>();
            this.itemCache.put(extractor, cache);
        }
        if (items != null) {
            for (ItemDescriptor descriptor : items.keySet()) {
                String localId = this.makeId(prefix, descriptor.getLocalId());
                this.getOrCreateItem(extractor, prefix, cache, descriptor, localId);
            }
        }
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("parser.error", Variant.TRUE);
        attributes.put("parser.error.message", Variant.valueOf((Object)ExceptionHelper.extractMessage((Throwable)throwable)));
        attributes.put("timestamp", this.lastError);
        for (DataItemInputChained item : cache.values()) {
            item.updateData(Variant.NULL, attributes, AttributeMode.SET);
        }
    }

    private void setValues(Extractor extractor, String prefix, Map<ItemDescriptor, ItemValue> itemValues) {
        this.lastError = null;
        Map<String, DataItemInputChained> cache = this.itemCache.get(extractor);
        if (cache == null) {
            cache = new HashMap<String, DataItemInputChained>();
            this.itemCache.put(extractor, cache);
        }
        HashSet<String> keys = new HashSet<String>(cache.keySet());
        for (Map.Entry<ItemDescriptor, ItemValue> entry : itemValues.entrySet()) {
            String localId = this.makeId(prefix, entry.getKey().getLocalId());
            DataItemInputChained item = this.getOrCreateItem(extractor, prefix, cache, entry.getKey(), localId);
            keys.remove(localId);
            item.updateData(entry.getValue().getValue(), entry.getValue().getAttributes(), AttributeMode.SET);
        }
        for (String remove : keys) {
            this.disposeItem(extractor, remove);
        }
    }

    private DataItemInputChained getOrCreateItem(Extractor extractor, String prefix, Map<String, DataItemInputChained> cache, ItemDescriptor descriptor, String localId) {
        DataItemInputChained item = cache.get(localId);
        if (item == null) {
            item = this.createItem(extractor, prefix, descriptor);
        }
        return item;
    }

    private void disposeItem(Extractor extractor, String localId) {
        logger.debug("Dispose item: {}", (Object)localId);
        Map<String, DataItemInputChained> cache = this.itemCache.get(extractor);
        DataItemInputChained item = cache.remove(localId);
        if (item == null) {
            logger.debug("Item not found");
            return;
        }
        this.storage.removed(new org.eclipse.scada.da.server.browser.common.query.ItemDescriptor((DataItem)item, null));
        this.itemFactory.disposeItem(localId);
    }

    private DataItemInputChained createItem(Extractor extractor, String prefix, ItemDescriptor descriptor) {
        String localId = this.makeId(prefix, descriptor.getLocalId());
        DataItemInputChained item = this.itemFactory.createInput(localId, descriptor.getAttributes());
        Map<String, DataItemInputChained> cache = this.itemCache.get(extractor);
        if (cache == null) {
            cache = new HashMap<String, DataItemInputChained>();
            this.itemCache.put(extractor, cache);
        }
        cache.put(localId, item);
        this.storage.added(new org.eclipse.scada.da.server.browser.common.query.ItemDescriptor((DataItem)item, descriptor.getAttributes()));
        return item;
    }

    private String makeId(String prefix, String localId) {
        if (prefix != null) {
            return String.valueOf(prefix) + "." + localId;
        }
        return localId;
    }

    protected void performStart() {
        this.itemFactory = new ComponentItemFactory(this.hive, (ItemStorage)this.storage, this.prefix);
        for (Input input : this.inputs) {
            logger.debug("Starting input: {}", (Object)input);
            input.start();
        }
    }

    protected void performStop() {
        for (Input input : this.inputs) {
            logger.debug("Stopping input: {}", (Object)input);
            input.stop();
        }
        this.storage.clear();
        this.itemFactory.dispose();
        this.itemCache.clear();
    }
}

