/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.slave.inject.postgres;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.BaseStorage;
import org.eclipse.scada.ae.server.storage.Query;
import org.eclipse.scada.ae.server.storage.StoreListener;
import org.eclipse.scada.ae.server.storage.postgres.EventConverter;
import org.eclipse.scada.ae.server.storage.postgres.JdbcDao;
import org.eclipse.scada.ae.server.storage.postgres.NodeIdProvider;
import org.eclipse.scada.ae.slave.inject.postgres.Activator;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.osgi.BundleObjectInputStream;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.SingleColumnRowMapper;
import org.eclipse.scada.utils.osgi.jdbc.pool.PoolConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventInjector
extends BaseStorage {
    private static final Logger logger = LoggerFactory.getLogger(EventInjector.class);
    private static final String replicateEventSelectSql = "SELECT id, entry_timestamp, node_id, data FROM %sES_AE_REP LIMIT %s;";
    private static final String replicateEventDeleteSql = "DELETE FROM %sES_AE_REP WHERE ID = ?;";
    private static final String eventExistsSql = "SELECT count(id) FROM %sES_AE_EVENTS_HSTORE WHERE ID = ?::UUID;";
    private final boolean deleteFailed = Boolean.getBoolean("org.eclipse.scada.ae.slave.inject.postgres.deleteFailed");
    private final CommonConnectionAccessor accessor;
    private final JdbcDao jdbcDao;
    private final ScheduledExportedExecutorService scheduler;
    private final String schema;
    private final String replicationSchema;

    public EventInjector(DataSourceFactory dataSourceFactory, Properties dataSourceProperties, Integer delay, boolean usePool, Long loginTimeout, String schema, String replicationSchema, String instance) throws SQLException {
        logger.info("Starting event injector");
        this.schema = schema;
        this.replicationSchema = replicationSchema;
        this.accessor = usePool ? new PoolConnectionAccessor(dataSourceFactory, dataSourceProperties) : new DataSourceConnectionAccessor(dataSourceFactory, dataSourceProperties, loginTimeout);
        this.jdbcDao = new JdbcDao(this.accessor, schema, instance, new NodeIdProvider(){

            public String getNodeId() {
                return EventInjector.this.getNodeId();
            }
        });
        this.scheduler = new ScheduledExportedExecutorService("org.eclipse.scada.ae.slave.inject.postgres", 1);
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                EventInjector.this.process();
            }
        }, 0L, (long)delay.intValue(), TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        logger.info("Disposing event injector ...");
        this.scheduler.shutdown();
        logger.info("Disposing event injector ... done!");
    }

    private void process() {
        try {
            int result = this.doProcess();
            if (result > 0) {
                logger.info("Processed {} entries", (Object)result);
            } else {
                logger.debug("Processed {} entries", (Object)result);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to process", (Throwable)e);
        }
    }

    private int doProcess() {
        return (Integer)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Integer>(){

            protected Integer performTask(final ConnectionContext connectionContext) throws Exception {
                final AtomicInteger i = new AtomicInteger(0);
                connectionContext.setAutoCommit(false);
                connectionContext.query(new RowCallback(){

                    public void processRow(ResultSet resultSet) throws SQLException {
                        EventInjector.this.processRow(resultSet, connectionContext);
                        i.incrementAndGet();
                    }
                }, String.format(EventInjector.replicateEventSelectSql, EventInjector.this.schema, EventInjector.this.getLimit()), new Object[0]);
                connectionContext.commit();
                return i.get();
            }
        });
    }

    private Integer getLimit() {
        return Integer.getInteger("org.eclipse.scada.ae.slave.inject.postgres.limit", 2000);
    }

    private void processRow(ResultSet resultSet, ConnectionContext connectionContext) throws SQLException {
        block3: {
            String id = resultSet.getString(1);
            logger.debug("Processing event {}", (Object)id);
            if (this.entryExists(connectionContext, id)) {
                logger.debug("Entry exists ... only delete");
                this.deleteReplicationEntry(connectionContext, id);
                return;
            }
            Timestamp entryTimestamp = resultSet.getTimestamp(2);
            String nodeId = resultSet.getString(3);
            logger.trace("Injecting event {} from node {}, timeDiff: {} ms", new Object[]{id, nodeId, System.currentTimeMillis() - entryTimestamp.getTime()});
            try {
                logger.debug("Storing event");
                this.jdbcDao.store(connectionContext, this.toEvent(resultSet));
                this.deleteReplicationEntry(connectionContext, id);
            }
            catch (Exception e) {
                logger.warn("Failed to decode and store event", (Throwable)e);
                if (!this.deleteFailed) break block3;
                this.deleteReplicationEntry(connectionContext, id);
            }
        }
    }

    private Event toEvent(ResultSet resultSet) throws SQLException, IOException, ClassNotFoundException {
        byte[] data;
        switch (this.jdbcDao.dataFormat) {
            case JSON: {
                return EventConverter.INSTANCE.toEvent(resultSet.getString(4));
            }
            case BLOB: {
                Blob blob = resultSet.getBlob(4);
                data = blob.getBytes(0L, Long.valueOf(blob.length()).intValue());
                blob.free();
                break;
            }
            default: {
                data = resultSet.getBytes(4);
            }
        }
        logger.trace("Deserialize event");
        BundleObjectInputStream stream = new BundleObjectInputStream((InputStream)new ByteArrayInputStream(data), Activator.getContext().getBundle());
        try {
            Object o = stream.readObject();
            if (o instanceof Event) {
                Event event = (Event)o;
                return event;
            }
            if (o == null) {
                logger.warn("Found null event");
                return null;
            }
            logger.warn("Expected event type {} but found {}. Discarding...", Event.class, o.getClass());
            return null;
        }
        finally {
            stream.close();
        }
    }

    private boolean entryExists(ConnectionContext connectionContext, String id) throws SQLException {
        logger.debug("Checking if entry already exists");
        List result = connectionContext.query((RowMapper)new SingleColumnRowMapper(Number.class), String.format(eventExistsSql, this.replicationSchema), new Object[]{id});
        if (result.isEmpty()) {
            return false;
        }
        return ((Number)result.get(0)).intValue() > 0;
    }

    private void deleteReplicationEntry(ConnectionContext connectionContext, String id) throws SQLException {
        connectionContext.update(String.format(replicateEventDeleteSql, this.schema), new Object[]{id});
    }

    public Event store(Event event, StoreListener listener) {
        throw new UnsupportedOperationException();
    }

    public Query query(String filter) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Event update(UUID id, String comment, StoreListener listener) throws Exception {
        throw new UnsupportedOperationException();
    }
}

