/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.internal.MasterItemImpl;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.ExecutorServiceExporterImpl;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class MasterFactory
extends AbstractServiceConfigurationFactory<MasterItemImpl> {
    public static final String ITEM_ID = "item.id";
    public static final String CONNECTION_ID = "connection.id";
    private final ExecutorService executor;
    private final ObjectPoolImpl<DataSource> dataSourcePool;
    private final ObjectPoolImpl<MasterItem> masterItemPool;
    private final ServiceRegistration<?> dataSourcePoolHandler;
    private final ServiceRegistration<?> masterItemPoolHandler;
    private final ObjectPoolTracker<DataSource> objectPoolTracker;
    private final ExecutorServiceExporterImpl executorExporter;

    public MasterFactory(BundleContext context, ObjectPoolTracker<DataSource> dataSourceTracker) {
        super(context);
        this.objectPoolTracker = dataSourceTracker;
        this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("MasterItemFactory"));
        this.executorExporter = new ExecutorServiceExporterImpl(this.executor, "MasterItemFactory");
        this.dataSourcePool = new ObjectPoolImpl();
        this.dataSourcePoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.dataSourcePool, DataSource.class);
        this.masterItemPool = new ObjectPoolImpl();
        this.masterItemPoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.masterItemPool, MasterItem.class);
    }

    protected AbstractServiceConfigurationFactory.Entry<MasterItemImpl> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        MasterItemImpl service = new MasterItemImpl(this.executor, context, configurationId, this.objectPoolTracker);
        service.update(parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", configurationId);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "Master Data Item");
        this.dataSourcePool.addService(configurationId, (Object)service, properties);
        this.masterItemPool.addService(configurationId, (Object)service, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, MasterItemImpl service) {
        this.dataSourcePool.removeService(configurationId, (Object)service);
        this.masterItemPool.removeService(configurationId, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<MasterItemImpl> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<MasterItemImpl> entry, Map<String, String> parameters) throws Exception {
        ((MasterItemImpl)entry.getService()).update(parameters);
        return null;
    }

    public synchronized void dispose() {
        super.dispose();
        this.dataSourcePoolHandler.unregister();
        this.masterItemPoolHandler.unregister();
        this.dataSourcePool.dispose();
        this.masterItemPool.dispose();
        this.executorExporter.dispose();
        this.executor.shutdown();
    }
}

