/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.iec60870;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.SingleSubscriptionManager;
import org.eclipse.scada.da.server.exporter.iec60870.InformationBean;
import org.eclipse.scada.da.server.exporter.iec60870.MappingEntry;
import org.eclipse.scada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.scada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.scada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.scada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.scada.protocol.iec60870.asdu.types.QualityInformation;
import org.eclipse.scada.protocol.iec60870.asdu.types.Value;
import org.eclipse.scada.protocol.iec60870.io.MirrorCommand;
import org.eclipse.scada.protocol.iec60870.server.data.AbstractBaseDataModel;
import org.eclipse.scada.protocol.iec60870.server.data.BackgroundIterator;
import org.eclipse.scada.protocol.iec60870.server.data.DataListener;
import org.eclipse.scada.protocol.iec60870.server.data.DefaultSubscription;
import org.eclipse.scada.protocol.iec60870.server.data.Subscription;
import org.eclipse.scada.protocol.iec60870.server.data.event.MessageBuilder;
import org.eclipse.scada.protocol.iec60870.server.data.event.SimpleBooleanBuilder;
import org.eclipse.scada.protocol.iec60870.server.data.event.SimpleFloatBuilder;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModelImpl
extends AbstractBaseDataModel {
    private static final SimpleFloatBuilder FLOAT_BUILDER = new SimpleFloatBuilder(false);
    private static final SimpleBooleanBuilder BOOLEAN_BUILDER = new SimpleBooleanBuilder(false);
    private static final Logger logger = LoggerFactory.getLogger(DataModelImpl.class);
    private final SingleSubscriptionManager manager;
    private final Map<Integer, SortedMap<Integer, Value<?>>> cache;
    private final InformationBean info;
    private final ExecutorService backgroundExecutor;
    private final Map<AddressKey, String> addressMap = new HashMap<AddressKey, String>();

    public DataModelImpl(HiveSource hiveSource, Set<MappingEntry> entries, Properties hiveProperties, InformationBean info) {
        super("org.eclipse.scada.da.server.exporter.iec60870.DataModel");
        this.backgroundExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.da.server.exporter.iec60870.DataModel/background"));
        this.info = info;
        for (MappingEntry entry : entries) {
            this.addressMap.put(new AddressKey(entry.getAsduAddress(), entry.getAddress()), entry.getItemId());
        }
        this.cache = new HashMap();
        this.manager = new SingleSubscriptionManager((ScheduledExecutorService)this.executor, hiveSource, hiveProperties, "IEC60870/DataModel");
        this.manager.start();
        this.attach(entries);
    }

    public synchronized Subscription subscribe(DataListener listener) {
        Subscription result = super.subscribe(listener);
        this.info.setNumberOfSubscriptions(this.getNumberOfSubscriptions());
        return result;
    }

    protected synchronized ListenableFuture<Void> disposeSubscription(DefaultSubscription subscription) {
        ListenableFuture result = super.disposeSubscription(subscription);
        this.info.setNumberOfSubscriptions(this.getNumberOfSubscriptions());
        return result;
    }

    private void attach(Set<MappingEntry> entries) {
        for (final MappingEntry entry : entries) {
            logger.debug("Attaching to: {}", (Object)entry);
            this.handleStateChanged(entry, DataItemValue.DISCONNECTED, false);
            this.manager.addListener(entry.getItemId(), new SingleSubscriptionManager.Listener(){

                public void stateChanged(String itemId, DataItemValue value) {
                    DataModelImpl.this.handleStateChanged(entry, value, true);
                }
            });
        }
    }

    protected synchronized void handleStateChanged(MappingEntry entry, DataItemValue value, boolean notify) {
        logger.trace("Handle state change - entry: {}, value: {}", (Object)entry, (Object)value);
        SortedMap<Integer, Value<?>> unit = this.cache.get(entry.getAsduAddress());
        if (unit == null) {
            unit = new TreeMap();
            this.cache.put(entry.getAsduAddress(), unit);
        }
        Value<?> iecValue = this.convert(entry, value);
        logger.trace("Converted to: {}", iecValue);
        unit.put(entry.getAddress(), iecValue);
        this.notifyChange(entry, iecValue);
    }

    private Value<?> convert(MappingEntry entry, DataItemValue value) {
        Variant v = value.getValue();
        if (v == null) {
            v = Variant.NULL;
        }
        try {
            Object cv = value.getValue() == null || value.getValue().isNull() ? null : this.convertValue(entry, value);
            if (cv == null) {
                return this.errorValue(entry);
            }
            return new Value(cv, this.convertTimestamp(value), this.convertQuality(value));
        }
        catch (Exception e) {
            logger.debug("Conversion error", (Throwable)e);
            return this.errorValue(entry);
        }
    }

    private long convertTimestamp(DataItemValue value) {
        if (value == null) {
            return System.currentTimeMillis();
        }
        Variant ts = (Variant)value.getAttributes().get("timestamp");
        if (ts == null || ts.isNull()) {
            return System.currentTimeMillis();
        }
        return ts.asLong(Long.valueOf(System.currentTimeMillis()));
    }

    private Object convertValue(MappingEntry entry, DataItemValue value) throws NullValueException, NotConvertableException {
        Variant v = value.getValue();
        if (v == null) {
            v = Variant.NULL;
        }
        if (entry.getValueType() == null) {
            Serializable ov = v.getValue();
            if (ov instanceof Number) {
                return Float.valueOf(((Number)ov).floatValue());
            }
            if (ov instanceof String) {
                return Double.parseDouble((String)((Object)ov));
            }
            return ov;
        }
        switch (entry.getValueType()) {
            case BOOLEAN: {
                return v.asBoolean();
            }
            case FLOAT: {
                return Float.valueOf((float)v.asDouble());
            }
        }
        throw new IllegalStateException(String.format("Value type %s unknown", new Object[]{entry.getValueType()}));
    }

    private QualityInformation convertQuality(DataItemValue value) {
        boolean valid = value.isConnected() && !value.isError();
        boolean substituted = value.isManual();
        boolean blocked = value.isBlocked();
        return new QualityInformation(blocked, substituted, true, valid);
    }

    private Value<?> errorValue(MappingEntry entry) {
        switch (entry.getValueType()) {
            case FLOAT: {
                return new Value((Object)Float.valueOf(0.0f), System.currentTimeMillis(), QualityInformation.INVALID);
            }
        }
        return new Value((Object)false, System.currentTimeMillis(), QualityInformation.INVALID);
    }

    public void dispose() {
        this.manager.stop();
        this.backgroundExecutor.shutdown();
        super.dispose();
    }

    public void disposeAndWait() throws InterruptedException {
        super.disposeAndWait();
        this.backgroundExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public ListenableFuture<Value<?>> read(final ASDUAddress asduAddress, final InformationObjectAddress address) {
        return this.executor.submit(new Callable<Value<?>>(){

            @Override
            public Value<?> call() throws Exception {
                return DataModelImpl.this.performRead(asduAddress, address);
            }
        });
    }

    protected synchronized Value<?> performRead(ASDUAddress asduAddress, InformationObjectAddress address) {
        Map map = this.cache.get(asduAddress.getAddress());
        if (map == null) {
            return null;
        }
        return (Value)map.get(address.getAddress());
    }

    public synchronized ListenableFuture<Void> readAll(final ASDUAddress asduAddress, Runnable prepare, final DataListener listener) {
        Map map = this.cache.get(asduAddress.getAddress());
        if (map == null) {
            return null;
        }
        final HashMap map2 = new HashMap(map);
        this.executor.submit(prepare);
        return this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                DataModelImpl.this.performReadAll(asduAddress, listener, map2);
                return null;
            }
        });
    }

    protected synchronized void performReadAll(ASDUAddress asduAddress, DataListener listener, Map<Integer, Value<?>> map) {
        for (Map.Entry<Integer, Value<?>> entry : map.entrySet()) {
            DataModelImpl.fireListener(asduAddress, listener, entry);
        }
    }

    public void forAllAsdu(final Function<ASDUAddress, Void> function, final Runnable ifNoneFound) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataModelImpl.this.performForAllAsdu((Function<ASDUAddress, Void>)function, ifNoneFound);
            }
        });
    }

    protected synchronized void performForAllAsdu(final Function<ASDUAddress, Void> function, Runnable ifNoneFound) {
        if (this.cache.isEmpty()) {
            this.executor.execute(ifNoneFound);
            return;
        }
        for (final Integer asdu : this.cache.keySet()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    function.apply((Object)ASDUAddress.valueOf((int)asdu));
                }
            });
        }
    }

    public BackgroundIterator createBackgroundIterator() {
        return new BackgroundIteratorImpl();
    }

    public Object proceedBackgroundScan(final BackgroundState state) {
        try {
            logger.debug("Background scan - {}", (Object)state);
            Object msg = this.backgroundExecutor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return DataModelImpl.this.internalBackgroundScan(state);
                }
            }).get();
            logger.debug("Background scan result - {}", msg);
            return msg;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to perform background scan", e);
        }
    }

    protected synchronized Object internalBackgroundScan(BackgroundState state) {
        Map.Entry<Integer, Value<?>> entry;
        if (state.asduAddressIterator == null) {
            state.asduAddressIterator = this.cache.entrySet().iterator();
        }
        if (state.asduAddress == null) {
            if (!state.asduAddressIterator.hasNext()) {
                return null;
            }
            state.asduAddress = state.asduAddressIterator.next();
        }
        if (state.addressIterator == null) {
            state.addressMap = state.asduAddress.getValue();
            state.addressIterator = state.addressMap.entrySet().iterator();
        }
        MessageBuilder<?, ?> builder = null;
        do {
            if (!state.addressIterator.hasNext()) {
                state.addressIterator = null;
                state.asduAddress = null;
                if (builder != null) {
                    return builder.build();
                }
                return null;
            }
            entry = state.addressIterator.next();
            if (builder == null) {
                builder = DataModelImpl.createBuilder(entry.getValue().getValue());
                builder.start(CauseOfTransmission.BACKGROUND, ASDUAddress.valueOf((int)state.asduAddress.getKey()));
            }
            if (builder.accepts(entry.getValue())) continue;
            state.addressMap = state.asduAddress.getValue().tailMap(entry.getKey());
            state.addressIterator = state.addressMap.entrySet().iterator();
            return builder.build();
        } while (builder.addEntry(InformationObjectAddress.valueOf((int)entry.getKey()), entry.getValue()));
        return builder.build();
    }

    private void notifyChange(MappingEntry entry, Value<?> iecValue) {
        Object rawValue;
        logger.trace("Notify raw value: {} ({})", rawValue, (rawValue = iecValue.getValue()) != null ? rawValue.getClass() : null);
        if (rawValue instanceof Boolean) {
            this.notifyChangeBoolean(ASDUAddress.valueOf((int)entry.getAsduAddress()), new InformationObjectAddress(entry.getAddress()), Collections.singletonList(iecValue));
        } else if (rawValue instanceof Float) {
            this.notifyChangeFloat(ASDUAddress.valueOf((int)entry.getAsduAddress()), new InformationObjectAddress(entry.getAddress()), Collections.singletonList(iecValue));
        }
    }

    private static void fireListener(ASDUAddress asduAddress, DataListener listener, Map.Entry<Integer, Value<?>> entry) {
        Value<?> ve = entry.getValue();
        Object v = ve.getValue();
        if (v instanceof Boolean) {
            listener.dataChangeBoolean(asduAddress, InformationObjectAddress.valueOf((int)entry.getKey()), Collections.singletonList(ve));
        } else if (v instanceof Float) {
            listener.dataChangeFloat(asduAddress, InformationObjectAddress.valueOf((int)entry.getKey()), Collections.singletonList(ve));
        }
    }

    private static MessageBuilder<?, ?> createBuilder(Object value) {
        if (value instanceof Boolean) {
            return BOOLEAN_BUILDER.create();
        }
        if (value instanceof Number) {
            return FLOAT_BUILDER.create();
        }
        throw new IllegalStateException(String.format("Value type %s is unsupported", value.getClass()));
    }

    private WriteRequest convert(ASDUHeader header, InformationObjectAddress informationObjectAddress, Variant value) {
        return new WriteRequest(header.getAsduAddress(), informationObjectAddress, value);
    }

    public void writeCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.performWrite(header, informationObjectAddress, Variant.valueOf((boolean)state), mirrorCommand, execute);
    }

    public void writeValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, float value, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.performWrite(header, informationObjectAddress, Variant.valueOf((double)value), mirrorCommand, execute);
    }

    public void writeScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.performWrite(header, informationObjectAddress, Variant.valueOf((int)value), mirrorCommand, execute);
    }

    private void performWrite(ASDUHeader header, InformationObjectAddress informationObjectAddress, Variant value, final MirrorCommand mirrorCommand, final boolean execute) {
        final WriteRequest request = this.convert(header, informationObjectAddress, value);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!DataModelImpl.this.performWrite(request, mirrorCommand, execute)) {
                    mirrorCommand.sendActivationConfirm(false);
                }
            }
        });
    }

    protected synchronized boolean performWrite(final WriteRequest request, final MirrorCommand mirrorCommand, boolean execute) {
        logger.debug("Request to write - request: {}, execute: {}", (Object)request, (Object)execute);
        final String itemId = this.addressMap.get(new AddressKey(request.getAsduAddress().getAddress(), request.getAddress().getAddress()));
        if (itemId == null) {
            logger.info("Item for request not found - request: {}", (Object)request);
            return false;
        }
        logger.debug("Request to write to item: {}", (Object)itemId);
        mirrorCommand.sendActivationConfirm(true);
        if (execute) {
            NotifyFuture future = this.manager.writeValue(itemId, request.getValue(), null, null);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Write command completed - request: {}, item: {}", (Object)request, (Object)itemId);
                    mirrorCommand.sendActivationTermination();
                }
            });
        }
        return true;
    }

    private static final class AddressKey {
        private final int asduAddress;
        private final int address;

        public AddressKey(int asduAddress, int address) {
            this.asduAddress = asduAddress;
            this.address = address;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.address;
            result = 31 * result + this.asduAddress;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddressKey other = (AddressKey)obj;
            if (this.address != other.address) {
                return false;
            }
            return this.asduAddress == other.asduAddress;
        }
    }

    private final class BackgroundIteratorImpl
    implements BackgroundIterator {
        private final BackgroundState state = new BackgroundState();

        private BackgroundIteratorImpl() {
        }

        public Object nextMessage() {
            return DataModelImpl.this.proceedBackgroundScan(this.state);
        }
    }

    private static final class BackgroundState {
        public Map.Entry<Integer, SortedMap<Integer, Value<?>>> asduAddress;
        public Iterator<Map.Entry<Integer, SortedMap<Integer, Value<?>>>> asduAddressIterator;
        public Iterator<Map.Entry<Integer, Value<?>>> addressIterator;
        public SortedMap<Integer, Value<?>> addressMap;

        private BackgroundState() {
        }

        public String toString() {
            return String.format("[asduAddress: %s, asduAddressIterator: %s, addressMap: %s, addressIterator: %s]", this.asduAddress, this.asduAddressIterator, this.addressMap, this.addressIterator);
        }
    }

    private static class WriteRequest {
        private final ASDUAddress asduAddress;
        private final InformationObjectAddress address;
        private final Variant value;

        public WriteRequest(ASDUAddress asduAddress, InformationObjectAddress address, Variant value) {
            this.asduAddress = asduAddress;
            this.address = address;
            this.value = value;
        }

        public InformationObjectAddress getAddress() {
            return this.address;
        }

        public ASDUAddress getAsduAddress() {
            return this.asduAddress;
        }

        public Variant getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("[WriteRequest - asduAddress: %s, objectAddress: %s, value: %s", this.asduAddress, this.address, this.value);
        }
    }
}

