/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.mapper;

import java.util.Dictionary;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.mapper.ValueMapper;
import org.eclipse.scada.da.mapper.ValueMapperListener;
import org.eclipse.scada.da.master.AbstractMasterHandlerImpl;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;

public class MapperMasterHandler
extends AbstractMasterHandlerImpl
implements ValueMapperListener {
    private String sourceAttributeName;
    private String targetAttributeName;
    private final ObjectPoolTracker<ValueMapper> mapperPoolTracker;
    private volatile ValueMapper mapper;
    private SingleObjectPoolServiceTracker<ValueMapper> mapperTracker;
    private final String id;

    public MapperMasterHandler(String id, ObjectPoolTracker<MasterItem> poolTracker, ObjectPoolTracker<ValueMapper> mapperPoolTracker, int defaultPriority) {
        super(poolTracker, defaultPriority);
        this.id = id;
        this.mapperPoolTracker = mapperPoolTracker;
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        super.update(userInformation, parameters);
        if (this.mapperTracker != null) {
            this.mapperTracker.close();
            this.mapperTracker = null;
        }
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.mapperTracker = new SingleObjectPoolServiceTracker(this.mapperPoolTracker, cfg.getStringChecked("mapper.id", "'mapper.id' must be specified"), (SingleObjectPoolServiceTracker.ServiceListener)new SingleObjectPoolServiceTracker.ServiceListener<ValueMapper>(){

            public void serviceChange(ValueMapper service, Dictionary<?, ?> properties) {
                MapperMasterHandler.this.setMapper(service);
            }
        });
        this.sourceAttributeName = cfg.getString("sourceAttributeName");
        this.targetAttributeName = cfg.getString("targetAttributeName");
        this.mapperTracker.open();
        this.reprocess();
    }

    protected void setMapper(ValueMapper mapper) {
        if (this.mapper != null) {
            this.mapper.removeListener((ValueMapperListener)this);
        }
        this.mapper = mapper;
        if (this.mapper != null) {
            this.mapper.addListener((ValueMapperListener)this);
        }
        this.reprocess();
    }

    public synchronized void dataUpdate(Map<String, Object> context, DataItemValue.Builder builder) {
        Variant sourceValue = this.sourceAttributeName == null || this.sourceAttributeName.isEmpty() ? builder.getValue() : (Variant)builder.getAttributes().get(this.sourceAttributeName);
        ValueMapper mapper = this.getMapper();
        if (mapper != null) {
            if (this.targetAttributeName == null || this.targetAttributeName.isEmpty()) {
                builder.setValue(mapper.mapValue(sourceValue));
            } else {
                builder.setAttribute(this.targetAttributeName, mapper.mapValue(sourceValue));
            }
        } else {
            builder.setAttribute(String.valueOf(this.id) + ".mapperMissing", Variant.TRUE);
        }
    }

    protected ValueMapper getMapper() {
        return this.mapper;
    }

    public void stateChanged() {
        this.reprocess();
    }
}

