/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.common;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.server.storage.common.UpdatableQueryBuffer;
import org.eclipse.scada.hd.server.storage.common.ValueSourceManager;
import org.eclipse.scada.hds.ValueVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static final Logger logger = LoggerFactory.getLogger(QueryImpl.class);
    private final ValueSourceManager storage;
    private final ExecutorService executor;
    private final QueryListener listener;
    private final boolean updateData;
    private final UpdatableQueryBuffer buffer;
    private final AtomicReference<LoadState> state = new AtomicReference();

    public QueryImpl(ValueSourceManager storage, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor, QueryParameters parameters, QueryListener listener, boolean updateData, Date fixedStartDate, Date fixedEndDate) {
        this.storage = storage;
        this.executor = executor;
        this.listener = listener;
        this.updateData = updateData;
        this.buffer = new UpdatableQueryBuffer(this.listener, eventExecutor, fixedStartDate, fixedEndDate);
        this.state.set(new LoadState(false, false, false, parameters));
        this.changeParameters(parameters, true);
    }

    /*
     * Unable to fully structure code
     */
    public void close() {
        if (this.requestClose()) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            QueryImpl.logger.debug("Waiting for loader to complete");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                QueryImpl.logger.warn("Got interrupted while waiting for loader to complete", (Throwable)e);
                break;
            }
lbl10:
            // 2 sources

            ** while (this.state.get().isLoading())
        }
lbl11:
        // 2 sources

        this.buffer.close();
        this.storage.queryClosed(this);
    }

    private boolean requestClose() {
        LoadState update;
        LoadState expect;
        do {
            if (!(expect = this.state.get()).isClosed()) continue;
            logger.info("Query already closed");
            return false;
        } while (!this.state.compareAndSet(expect, update = new LoadState(true, expect.isLoading(), false, expect.getParameters())));
        logger.info("Close requested");
        return true;
    }

    public void changeParameters(QueryParameters parameters) {
        this.changeParameters(parameters, false);
    }

    public void changeParameters(QueryParameters parameters, boolean force) {
        boolean shouldStart;
        LoadState update;
        LoadState expect;
        logger.debug("Change parameters to - force: {}, parameters: {}", (Object)force, (Object)parameters);
        int i = 0;
        do {
            expect = this.state.get();
            logger.debug("Try parameter update - {} - {}", (Object)i, (Object)expect);
            if (expect.isClosed()) {
                logger.info("Query is closed. Bye!");
                return;
            }
            if (!force && QueryImpl.parameterEquals(expect.getParameters(), parameters)) {
                logger.info("This is not an actual parameter change. Aborting...");
                return;
            }
            shouldStart = !expect.isLoading();
            update = new LoadState(false, expect.isLoading(), force, parameters);
            logger.debug("Try to apply state: {}", (Object)update);
            ++i;
        } while (!this.state.compareAndSet(expect, update));
        if (shouldStart) {
            this.startLoad();
        }
        logger.debug("State applied: {} after {} iteration(s)", (Object)update, (Object)i);
    }

    private static boolean parameterEquals(QueryParameters first, QueryParameters second) {
        if (first == second) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (first.getStartTimestamp() != second.getStartTimestamp()) {
            return false;
        }
        if (first.getEndTimestamp() != second.getEndTimestamp()) {
            return false;
        }
        return first.getNumberOfEntries() == second.getNumberOfEntries();
    }

    public void reload() {
        logger.debug("reload");
        this.changeParameters(this.state.get().getParameters(), true);
    }

    private void startLoad() {
        logger.info("Starting load");
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                QueryImpl.this.performLoad();
            }
        });
    }

    protected void performLoad() {
        LoadState update;
        LoadState expect;
        logger.debug("Performing load");
        do {
            if ((expect = this.state.get()).isLoading()) {
                logger.debug("Found loading state. Bye!");
                return;
            }
            if (expect.isClosed()) {
                logger.debug("Found closed state. Bye!");
                return;
            }
            if (expect.isForceReload() || !QueryImpl.parameterEquals(this.buffer.getParameters(), expect.getParameters())) continue;
            logger.debug("Target state is no change from current state");
            return;
        } while (!this.state.compareAndSet(expect, update = new LoadState(false, true, false, expect.getParameters())));
        final LoadState current = expect;
        try {
            logger.debug("Processing: {}", (Object)current);
            this.buffer.changeParameters(current.getParameters());
            boolean complete = this.storage.visit(current.getParameters(), new ValueVisitor(){

                public boolean value(double value, Date date, boolean error, boolean manual) {
                    QueryImpl.this.buffer.insertData(value, date, error, manual);
                    boolean result = QueryImpl.this.shouldContinue(current.getParameters());
                    if (!result) {
                        logger.info("Requesting early stop");
                    }
                    return result;
                }
            });
            if (complete) {
                this.buffer.complete();
            }
            if (this.state.get().isClosed()) {
                logger.info("Query closed. Bye");
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to query", (Throwable)e);
            throw new RuntimeException("Failed to query", e);
        }
        finally {
            logger.debug("End loading");
            if (this.endLoading(current)) {
                logger.debug("Triggering loading restart");
                this.startLoad();
            }
            logger.debug("Loading ended");
        }
    }

    private boolean hasChanged(QueryParameters loadingParameters) {
        QueryParameters currentParameters = this.state.get().getParameters();
        return loadingParameters != currentParameters;
    }

    protected boolean shouldContinue(QueryParameters queryParameters) {
        LoadState currentState = this.state.get();
        if (currentState.isClosed()) {
            logger.debug("Detected closed query");
            return false;
        }
        if (this.hasChanged(queryParameters)) {
            logger.debug("Detected parameter change");
            return false;
        }
        return true;
    }

    private boolean endLoading(LoadState ours) {
        boolean needStart;
        LoadState update;
        LoadState expect;
        logger.debug("End loading - our state: {}", (Object)ours);
        do {
            boolean bl = needStart = !(update = new LoadState((expect = this.state.get()).isClosed(), false, false, expect.getParameters())).isClosed() && !QueryImpl.parameterEquals(ours.getParameters(), update.getParameters());
        } while (!this.state.compareAndSet(expect, update));
        logger.debug("State after loading - restart: {}, {}", (Object)needStart, (Object)update);
        return needStart;
    }

    public boolean isUpdateData() {
        return this.updateData;
    }

    public void updateData(double value, Date timestamp, boolean error, boolean manual) {
        if (this.state.get().isClosed()) {
            return;
        }
        this.buffer.updateData(value, timestamp, error, manual);
    }

    public void dataChanged(Date start, Date end) {
        logger.debug("dataChanged - start: {}, end: {}", (Object)start, (Object)end);
        LoadState current = this.state.get();
        logger.debug("currentState: {}", (Object)current);
        if (current != null && start.after(new Date(current.getParameters().getEndTimestamp()))) {
            logger.debug("Ignoring change since it is after our query data");
            return;
        }
        this.reload();
    }

    private static class LoadState {
        private final boolean loading;
        private final boolean closed;
        private final boolean forceReload;
        private final QueryParameters parameters;

        public LoadState(boolean closed, boolean loading, boolean forceReload, QueryParameters parameters) {
            this.closed = closed;
            this.loading = loading;
            this.forceReload = forceReload;
            this.parameters = parameters;
        }

        public QueryParameters getParameters() {
            return this.parameters;
        }

        public boolean isForceReload() {
            return this.forceReload;
        }

        public boolean isLoading() {
            return this.loading;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public String toString() {
            return String.format("[loading: %s, closed: %s, parameters: %s]", this.loading, this.closed, this.parameters);
        }
    }
}

