/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.BaseStorage;
import org.eclipse.scada.ae.server.storage.Query;
import org.eclipse.scada.ae.server.storage.StoreListener;
import org.eclipse.scada.ae.server.storage.memory.ListQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStorage
extends BaseStorage {
    private static final Logger logger = LoggerFactory.getLogger(MemoryStorage.class);
    private final SortedSet<Event> events = new TreeSet<Event>();

    public synchronized Query query(String filter) throws Exception {
        return new ListQuery(new ArrayList<Event>(this.events), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event store(Event event, StoreListener listener) {
        logger.debug("Storing event in memory buffer: {}", (Object)event);
        Event storedEvent = this.createEvent(event);
        MemoryStorage memoryStorage = this;
        synchronized (memoryStorage) {
            this.events.add(storedEvent);
        }
        if (listener != null) {
            listener.notify(storedEvent);
        }
        return storedEvent;
    }

    public Set<Event> getEvents() {
        return Collections.unmodifiableSet(this.events);
    }

    public synchronized Event update(UUID id, String comment, StoreListener listener) throws Exception {
        Event event = null;
        for (Event found : this.events) {
            if (!found.getId().equals(event)) continue;
            event = found;
            break;
        }
        if (event == null) {
            return null;
        }
        this.events.remove(event);
        Event updatedEvent = Event.create().event(event).attribute(Event.Fields.COMMENT, (Object)comment).build();
        this.events.add(updatedEvent);
        return updatedEvent;
    }
}

