/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.monitor.proxy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuery;
import org.eclipse.scada.ae.server.monitor.proxy.LocalMonitorQueryListener;
import org.eclipse.scada.ae.server.monitor.proxy.RemoteMonitorQueryListener;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMonitorQuery
extends MonitorQuery {
    private static final Logger logger = LoggerFactory.getLogger(ProxyMonitorQuery.class);
    private final Map<String, RemoteMonitorQueryListener> remoteListenerMap = new HashMap<String, RemoteMonitorQueryListener>();
    private final Map<String, LocalMonitorQueryListener> localListenerMap = new HashMap<String, LocalMonitorQueryListener>();
    private final BundleContext context;
    private final Lock lock = new ReentrantLock();

    public ProxyMonitorQuery(BundleContext context, Executor executor) {
        super(executor);
        this.context = context;
    }

    public synchronized void dispose() {
        this.lock.lock();
        try {
            for (RemoteMonitorQueryListener remoteMonitorQueryListener : this.remoteListenerMap.values()) {
                remoteMonitorQueryListener.dispose();
            }
            this.remoteListenerMap.clear();
            for (LocalMonitorQueryListener localMonitorQueryListener : this.localListenerMap.values()) {
                localMonitorQueryListener.dispose();
            }
            this.localListenerMap.clear();
        }
        finally {
            this.lock.unlock();
        }
        super.dispose();
    }

    public void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        HashSet<String> remoteQueryStrings = new HashSet<String>();
        for (Map.Entry query : cfg.getPrefixed("remote.queries.").entrySet()) {
            remoteQueryStrings.add((String)query.getValue());
        }
        HashSet<String> localQueryStrings = new HashSet<String>();
        for (Map.Entry query : cfg.getPrefixed("local.queries.").entrySet()) {
            localQueryStrings.add((String)query.getValue());
        }
        this.lock.lock();
        try {
            this.setRemoteQueries(remoteQueryStrings);
            this.setLocalQueries(localQueryStrings);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setLocalQueries(Set<String> queryStrings) throws InvalidSyntaxException {
        HashSet<String> current = new HashSet<String>(this.localListenerMap.keySet());
        current.removeAll(queryStrings);
        for (String queryString : current) {
            LocalMonitorQueryListener queryListener = this.localListenerMap.remove(queryString);
            if (queryListener == null) continue;
            logger.info("Disposing query: {}", (Object)queryString);
            queryListener.dispose();
        }
        for (String queryString : queryStrings) {
            logger.info("Adding query: {}", (Object)queryString);
            LocalMonitorQueryListener MonitorQueryListener2 = this.createLocalQueryListener(queryString);
            this.localListenerMap.put(queryString, MonitorQueryListener2);
        }
    }

    private void setRemoteQueries(Set<String> queryStrings) {
        HashSet<String> current = new HashSet<String>(this.remoteListenerMap.keySet());
        current.removeAll(queryStrings);
        for (String queryString : current) {
            RemoteMonitorQueryListener queryListener = this.remoteListenerMap.remove(queryString);
            if (queryListener == null) continue;
            logger.info("Disposing query: {}", (Object)queryString);
            queryListener.dispose();
        }
        for (String queryString : queryStrings) {
            logger.info("Adding query: {}", (Object)queryString);
            String[] tok = queryString.split("#", 2);
            RemoteMonitorQueryListener MonitorQueryListener2 = this.createQueryListener(tok[0], tok[1]);
            this.remoteListenerMap.put(queryString, MonitorQueryListener2);
        }
    }

    private RemoteMonitorQueryListener createQueryListener(String connectionId, String monitorQueryId) {
        return new RemoteMonitorQueryListener(this.context, connectionId, monitorQueryId, this, this.lock);
    }

    private LocalMonitorQueryListener createLocalQueryListener(String monitorQueryId) throws InvalidSyntaxException {
        return new LocalMonitorQueryListener(this.context, monitorQueryId, this, this.lock);
    }

    void handleDataUpdate(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed) {
        logger.debug("handleDataUpdate - added: @{}, removed: @{}", new Object[]{addedOrUpdated == null ? -1 : addedOrUpdated.size(), removed == null ? -1 : removed.size()});
        this.updateData(addedOrUpdated, removed, false);
    }
}

