/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.mapper;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.mapper.ValueMapper;
import org.eclipse.scada.da.mapper.ValueMapperListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValueMapper
implements ValueMapper {
    private static final Logger logger = LoggerFactory.getLogger(AbstractValueMapper.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Map<String, String> data = new HashMap<String, String>();
    private final Set<ValueMapperListener> listeners = new LinkedHashSet<ValueMapperListener>();
    private Variant defaultValue = Variant.NULL;

    protected void configure(Map<String, String> data, Variant defaultValue) {
        ValueMapperListener[] listeners;
        try {
            this.writeLock.lock();
            this.data.clear();
            this.data.putAll(data);
            this.defaultValue = defaultValue;
            listeners = this.listeners.toArray(new ValueMapperListener[this.listeners.size()]);
        }
        finally {
            this.writeLock.unlock();
        }
        this.fireStateChange(listeners);
    }

    private void fireStateChange(ValueMapperListener[] listeners) {
        ValueMapperListener[] valueMapperListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ValueMapperListener listener = valueMapperListenerArray[n2];
            try {
                listener.stateChanged();
            }
            catch (Exception e) {
                logger.warn("Failed to handle state change", (Throwable)e);
            }
            ++n2;
        }
    }

    protected Variant defaultValue(Variant currentValue) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return currentValue;
    }

    @Override
    public Variant mapValue(Variant value) {
        if (value == null) {
            return this.defaultValue(value);
        }
        try {
            this.readLock.lock();
            String result = this.data.get(value.asString(null));
            if (result == null) {
                Variant variant = this.defaultValue(value);
                return variant;
            }
            Variant variant = Variant.valueOf((Object)result);
            return variant;
        }
        catch (Exception e) {
            logger.info("Failed to map value", (Throwable)e);
            Variant variant = this.defaultValue(value);
            return variant;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void dispose() {
        try {
            this.writeLock.lock();
            this.listeners.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addListener(ValueMapperListener listener) {
        try {
            this.writeLock.lock();
            this.listeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeListener(ValueMapperListener listener) {
        try {
            this.writeLock.lock();
            this.listeners.remove(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

