/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.ds;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataNodeTracker;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreDataSource
extends AbstractDataSource
implements DataListener {
    private static final Logger logger = LoggerFactory.getLogger(DataStoreDataSource.class);
    private static final String ATTR_TIMESTAMP = "timestamp";
    private final Executor executor;
    private boolean disposed;
    private final DataNodeTracker dataNodeTracker;
    private final String id;
    private String nodeId;
    private final BundleContext context;
    private Value currentNodeValue;

    public DataStoreDataSource(BundleContext context, String id, Executor executor, DataNodeTracker dataNodeTracker) {
        this.context = context;
        this.id = id;
        this.executor = executor;
        this.dataNodeTracker = dataNodeTracker;
        this.setError(null);
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        Value newValue = new Value(this.currentNodeValue);
        WriteAttributeResults initialResults = new WriteAttributeResults();
        this.handleTimestamp(initialResults, attributes, newValue);
        if (this.setNewValue(newValue)) {
            return new InstantFuture((Object)WriteAttributesHelper.errorUnhandled((WriteAttributeResults)initialResults, attributes));
        }
        return new InstantErrorFuture((Throwable)new OperationException("Unable to write to data store! Data store missing!"));
    }

    private void handleTimestamp(WriteAttributeResults initialResults, Map<String, Variant> attributes, Value newValue) {
        Variant timestampValue = attributes.get(ATTR_TIMESTAMP);
        if (timestampValue != null) {
            newValue.setTimestamp(timestampValue.asLong(null));
            initialResults.put((Object)ATTR_TIMESTAMP, (Object)WriteAttributeResult.OK);
        }
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        Value newValue = new Value(this.currentNodeValue);
        newValue.setValue(value);
        if (this.setNewValue(newValue)) {
            return new InstantFuture((Object)WriteResult.OK);
        }
        return new InstantErrorFuture((Throwable)new OperationException("Unable to write to data store! Data store missing!"));
    }

    private boolean setNewValue(Value newValue) {
        return this.dataNodeTracker.write(new DataNode(this.getNodeId(), (Serializable)newValue));
    }

    private String getNodeId() {
        return this.nodeId;
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        if (this.disposed) {
            return;
        }
        if (this.nodeId != null) {
            this.dataNodeTracker.removeListener(this.nodeId, (DataListener)this);
        }
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.nodeId = cfg.getString("node.id", "org.eclipse.scada.da.datasource.ds/" + this.id);
        this.dataNodeTracker.addListener(this.nodeId, (DataListener)this);
    }

    public synchronized void dispose() {
        this.disposed = true;
        if (this.nodeId != null) {
            this.dataNodeTracker.removeListener(this.nodeId, (DataListener)this);
            this.nodeId = null;
        }
    }

    protected Value convertValue(DataNode node) throws IOException, ClassNotFoundException {
        if (node == null) {
            return new Value();
        }
        Object value = node.getDataAsObject(this.context.getBundle());
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value instanceof Variant) {
            Value result = new Value();
            result.setValue((Variant)value);
            return result;
        }
        return new Value();
    }

    public void nodeChanged(DataNode node) {
        logger.debug("Node data changed: {}", (Object)node);
        try {
            this.currentNodeValue = this.convertValue(node);
            DataItemValue.Builder builder = new DataItemValue.Builder();
            builder.setSubscriptionState(SubscriptionState.CONNECTED);
            builder.setValue(this.currentNodeValue.getValue());
            if (this.currentNodeValue.getTimestamp() != null) {
                builder.setTimestamp(this.currentNodeValue.getTimestamp().longValue());
            }
            this.updateData(builder.build());
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    private void setError(Throwable e) {
        if (e != null) {
            logger.warn("Failed to read data", e);
        }
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setSubscriptionState(SubscriptionState.CONNECTED);
        builder.setValue(Variant.NULL);
        builder.setAttribute("node.error", Variant.TRUE);
        if (e != null) {
            builder.setAttribute("node.error.message", Variant.valueOf((Object)e.getMessage()));
        }
        this.updateData(builder.build());
    }

    private static class Value
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Variant value = Variant.NULL;
        private Long timestamp;

        public Value() {
        }

        public Value(Value other) {
            this.value = other.value;
            this.timestamp = other.timestamp;
        }

        public Variant getValue() {
            return this.value;
        }

        public void setValue(Variant value) {
            this.value = value;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

