/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.common;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.HiveSourceListener;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServiceListenerHiveSource
implements HiveSource {
    private final SingleServiceTracker<Hive> tracker;
    private final Set<HiveSourceListener> listeners = new HashSet<HiveSourceListener>();
    private final SingleServiceListener<Hive> listener = new SingleServiceListener<Hive>(){

        public void serviceChange(ServiceReference<Hive> reference, Hive service) {
            ServiceListenerHiveSource.this.handleServiceChange(service);
        }
    };
    private Hive service;
    private final Executor executor;

    public ServiceListenerHiveSource(BundleContext context, Executor executor) {
        this.executor = executor;
        this.tracker = new SingleServiceTracker(context, Hive.class, this.listener);
    }

    protected synchronized void handleServiceChange(final Hive service) {
        this.service = service;
        for (final HiveSourceListener listener : this.listeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.setHive(service);
                }
            });
        }
    }

    public void open() {
        this.tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.tracker.close();
        ServiceListenerHiveSource serviceListenerHiveSource = this;
        synchronized (serviceListenerHiveSource) {
            this.service = null;
            for (final HiveSourceListener listener : this.listeners) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.setHive(null);
                    }
                });
            }
        }
    }

    @Override
    public synchronized void addListener(final HiveSourceListener listener) {
        boolean added = this.listeners.add(listener);
        final Hive hive = this.service;
        if (added && hive != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.setHive(hive);
                }
            });
        }
    }

    @Override
    public synchronized void removeListener(HiveSourceListener listener) {
        this.listeners.remove(listener);
    }
}

