/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.server.common.DataItem;

public class SessionCommonData {
    private final Set<DataItem> items = new HashSet<DataItem>();
    private final Map<Object, Location> paths = new HashMap<Object, Location>();
    private final Map<Location, Object> pathRev = new HashMap<Location, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(DataItem item) {
        Set<DataItem> set = this.items;
        synchronized (set) {
            this.items.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(DataItem item) {
        Set<DataItem> set = this.items;
        synchronized (set) {
            this.items.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsItem(DataItem item) {
        Set<DataItem> set = this.items;
        synchronized (set) {
            return this.items.contains(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataItem> getItems() {
        Set<DataItem> set = this.items;
        synchronized (set) {
            return this.items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(Object tag, Location path) {
        Map<Object, Location> map = this.paths;
        synchronized (map) {
            this.paths.put(tag, path);
            this.pathRev.put(path, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(Location path) {
        Map<Object, Location> map = this.paths;
        synchronized (map) {
            Object tag = this.pathRev.get(path);
            if (tag != null) {
                this.pathRev.remove(path);
                this.paths.remove(tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTag(Location path) {
        Map<Object, Location> map = this.paths;
        synchronized (map) {
            return this.pathRev.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPath(Object tag) {
        Map<Object, Location> map = this.paths;
        synchronized (map) {
            return this.paths.containsKey(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Location> getPaths() {
        Map<Object, Location> map = this.paths;
        synchronized (map) {
            return this.paths;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPaths() {
        Map<Object, Location> map = this.paths;
        synchronized (map) {
            this.paths.clear();
            this.pathRev.clear();
        }
    }
}

