/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.ByteOrder;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.accessor.Int16Accessor;

public class WordAttribute
extends AbstractAttribute
implements Attribute {
    private final int index;
    private Short lastValue;
    private Variant lastTimestamp;
    private final boolean enableTimestamp;
    private final ByteOrder order;

    public WordAttribute(String name, int index, ByteOrder order, boolean enableTimestamp) {
        super(name);
        this.index = index;
        this.enableTimestamp = enableTimestamp;
        this.order = order;
    }

    @Override
    public void handleData(IoBuffer data, Map<String, Variant> attributes, Variant timestamp) {
        short s = this.order.get(data, this.toAddress(this.index), Int16Accessor.INSTANCE);
        attributes.put(this.name, Variant.valueOf((int)s));
        if (!Short.valueOf(s).equals(this.lastValue)) {
            this.lastValue = s;
            this.lastTimestamp = timestamp;
        }
        if (this.enableTimestamp) {
            attributes.put(String.valueOf(this.name) + ".timestamp", this.lastTimestamp);
        }
    }

    @Override
    public void handleError(Map<String, Variant> attributes) {
        this.lastValue = null;
        this.lastTimestamp = null;
    }

    @Override
    public void handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            throw new IllegalStateException("Device is not connected");
        }
        Integer i = value.asInteger(null);
        if (i != null) {
            IoBuffer data = IoBuffer.allocate((int)2);
            this.order.put(data, Int16Accessor.INSTANCE, i.shortValue());
            block.writeData(this.toAddress(this.index), data.array());
        }
    }
}

