/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.simulation.component.modules;

import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.simulation.component.Hive;
import org.eclipse.scada.da.server.simulation.component.modules.BaseModule;
import org.eclipse.scada.da.server.simulation.component.modules.MOV;

public class SimpleMOV
extends BaseModule
implements MOV,
Runnable {
    protected static final int JOB_PERIOD = 1000;
    protected static final int MOV_RUNTIME = 10000;
    private final long switchTime = 10000L;
    private long lastTick = 0L;
    private long switchRunning = 0L;
    private State switchTarget = null;
    private boolean error = false;
    private State state = State.CLOSED;
    private DataItemInputChained openInput = null;
    private DataItemInputChained closeInput = null;
    private DataItemInputChained transitInput = null;
    private DataItemInputChained errorInput = null;
    private DataItemInputChained runtimeInput = null;
    private DataItemInputChained percentInput = null;
    private DataItemCommand openCommand = null;
    private DataItemCommand closeCommand = null;
    private ScheduledExecutorService executor = null;

    public SimpleMOV(Hive hive, String id) {
        super(hive, "mov." + id);
        this.executor = hive.getExecutor();
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("tag", Variant.valueOf((Object)("mov." + id)));
        this.openInput = this.getInput("open-signal", attributes);
        this.closeInput = this.getInput("close-signal", attributes);
        this.transitInput = this.getInput("transit-signal", attributes);
        this.errorInput = this.getInput("error-signal", attributes);
        this.runtimeInput = this.getInput("runtime-value", attributes);
        this.percentInput = this.getInput("percent-value", attributes);
        this.lastTick = System.currentTimeMillis();
        this.executor.scheduleAtFixedRate(this, 0L, 1000L, TimeUnit.MILLISECONDS);
        this.openCommand = this.getOutput("open-command", attributes);
        this.openCommand.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                SimpleMOV.this.open();
            }
        });
        this.closeCommand = this.getOutput("close-command", attributes);
        this.closeCommand.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                SimpleMOV.this.close();
            }
        });
        this.update();
    }

    @Override
    public synchronized void close() {
        if (this.state.equals((Object)State.CLOSED)) {
            return;
        }
        this.startTransit(State.CLOSED, State.TRANSIT_CLOSE);
    }

    @Override
    public synchronized void open() {
        if (this.state.equals((Object)State.OPENED)) {
            return;
        }
        this.startTransit(State.OPENED, State.TRANSIT_OPEN);
    }

    public synchronized void startTransit(State target, State currentState) {
        if (this.switchTarget != null && this.switchTarget.equals((Object)target)) {
            return;
        }
        this.switchRunning = this.switchRunning > 0L ? 10000L - this.switchRunning : 10000L;
        this.switchTarget = target;
        this.state = currentState;
        this.update();
    }

    @Override
    public synchronized void setErrorState(boolean state) {
        this.error = state;
        if (this.error) {
            return;
        }
        this.error = state;
    }

    protected void setOpenStates(boolean open, boolean close) {
        this.openInput.updateData(Variant.valueOf((boolean)open), null, null);
        this.closeInput.updateData(Variant.valueOf((boolean)close), null, null);
        this.transitInput.updateData(Variant.valueOf((boolean)this.isTransit()), null, null);
    }

    protected synchronized void update() {
        if (this.error) {
            this.setOpenStates(true, true);
        } else {
            switch (this.state) {
                case CLOSED: {
                    this.setOpenStates(false, true);
                    this.percentInput.updateData(Variant.valueOf((double)0.0), null, null);
                    break;
                }
                case OPENED: {
                    this.setOpenStates(true, false);
                    this.percentInput.updateData(Variant.valueOf((double)1.0), null, null);
                    break;
                }
                case TRANSIT_CLOSE: {
                    this.setOpenStates(false, false);
                    this.percentInput.updateData(Variant.valueOf((double)((double)this.switchRunning / 10000.0)), null, null);
                    break;
                }
                case TRANSIT_OPEN: {
                    this.setOpenStates(false, false);
                    this.percentInput.updateData(Variant.valueOf((double)(1.0 - (double)this.switchRunning / 10000.0)), null, null);
                }
            }
        }
        this.errorInput.updateData(Variant.valueOf((boolean)this.error), null, null);
        this.runtimeInput.updateData(Variant.valueOf((long)this.switchRunning), null, null);
    }

    public boolean isTransit() {
        switch (this.state) {
            case TRANSIT_OPEN: {
                return true;
            }
            case TRANSIT_CLOSE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void run() {
        long ts = System.currentTimeMillis();
        long diff = ts - this.lastTick;
        this.lastTick = ts;
        this.switchRunning -= diff;
        if (this.switchRunning < 0L) {
            this.switchRunning = 0L;
        }
        if (this.switchTarget == null) {
            return;
        }
        if (this.switchRunning == 0L) {
            this.state = this.switchTarget;
            this.switchTarget = null;
        }
        this.update();
    }

    public static enum State {
        CLOSED,
        OPENED,
        TRANSIT_OPEN,
        TRANSIT_CLOSE;

    }
}

