/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.http.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.filter.EventMatcher;
import org.eclipse.scada.ae.filter.internal.EventMatcherImpl;
import org.eclipse.scada.ae.server.http.filter.EventFilter;
import org.eclipse.scada.ae.server.http.filter.FilterEntry;
import org.eclipse.scada.ae.server.http.filter.MatcherFilter;
import org.eclipse.scada.ae.server.http.filter.PriorityComparator;
import org.eclipse.scada.ae.server.http.filter.StaticFilter;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFilterImpl
implements EventFilter,
ConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(EventFilterImpl.class);
    private final ServiceRegistration<ConfigurationFactory> handle;
    private final List<FilterEntry> filters = new ArrayList<FilterEntry>();
    private final PriorityComparator priorityComparator = new PriorityComparator();
    private final Lock readLock;
    private final Lock writeLock;

    public EventFilterImpl(BundleContext context, String factoryId) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A configurable event filter");
        ((Dictionary)properties).put("factoryId", factoryId);
        this.handle = context.registerService(ConfigurationFactory.class, (Object)this, properties);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public void dispose() {
        this.handle.unregister();
    }

    @Override
    public boolean matches(Event event) {
        try {
            this.readLock.lock();
            Iterator<FilterEntry> i = this.filters.iterator();
            while (i.hasNext()) {
                if (!i.next().matches(event)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        try {
            this.writeLock.lock();
            this.internalDelete(configurationId);
            FilterEntry entry = this.createFilter(configurationId, properties);
            if (entry != null) {
                this.filters.add(entry);
            }
            this.resort();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private FilterEntry createFilter(String configurationId, Map<String, String> properties) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        String id = configurationId;
        long priority = cfg.getLongChecked("priority", "'priority' must be set");
        String type = cfg.getStringChecked("type", "'type' must be set");
        if (type.equalsIgnoreCase("static")) {
            boolean value = cfg.getBoolean("value", false);
            return new StaticFilter(id, priority, value);
        }
        if (type.equalsIgnoreCase("filter")) {
            String filterString = cfg.getStringChecked("filter", "'filter' must be set when type is 'filter'");
            EventMatcherImpl matcher = new EventMatcherImpl(filterString);
            return new MatcherFilter(id, priority, (EventMatcher)matcher);
        }
        logger.warn("Unable to create filter for type: '{}'", (Object)type);
        throw new RuntimeException(String.format("Filter type '%s' is unknown", type));
    }

    public void delete(UserInformation userInformation, String configurationId) throws Exception {
        try {
            this.writeLock.lock();
            this.internalDelete(configurationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void internalDelete(String configurationId) {
        Iterator<FilterEntry> i = this.filters.iterator();
        while (i.hasNext()) {
            if (!i.next().getId().equals(configurationId)) continue;
            i.remove();
        }
    }

    private void resort() {
        Collections.sort(this.filters, this.priorityComparator);
    }
}

