/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.ngp;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.scada.ae.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.ngp.Server;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.utils.lifecycle.LifecycleAware;

public class Exporter
implements LifecycleAware {
    private Server server;
    private final ProtocolConfigurationFactory protocolConfigurationFactory;
    private Collection<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
    private final Service service;

    public Exporter(Service service, ProtocolConfigurationFactory protocolConfigurationFactory, Collection<InetSocketAddress> addresses) {
        this.service = service;
        this.protocolConfigurationFactory = protocolConfigurationFactory;
        this.addresses = addresses;
    }

    public Exporter(Service service, ConnectionInformation connectionInformation) throws Exception {
        this(service, (ProtocolConfigurationFactory)new ProtocolConfigurationFactoryImpl(connectionInformation), Collections.singletonList(new InetSocketAddress(connectionInformation.getTarget(), (int)connectionInformation.getSecondaryTarget())));
    }

    public Class<? extends Service> getServiceClass() {
        return this.service.getClass();
    }

    private void createServer() throws Exception {
        this.server = new Server(this.addresses, this.protocolConfigurationFactory, this.service);
        this.server.start();
    }

    public void start() throws Exception {
        this.createServer();
    }

    public void stop() throws Exception {
        this.destroyServer();
    }

    private void destroyServer() {
        if (this.server != null) {
            this.server.dispose();
            this.server = null;
        }
    }
}

