/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.servlet;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.scada.ca.servlet.ListServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    private HttpService service;
    private HttpContext httpContext;
    private ServiceReference<?> serviceReference;
    private ListServlet servlet;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.addService(context.getServiceReference(HttpService.class));
        context.addServiceListener((ServiceListener)this, String.format("(%s=%s)", "objectClass", HttpService.class.getName()));
    }

    private void addService(ServiceReference<?> serviceReference) {
        if (serviceReference == null) {
            return;
        }
        this.service = (HttpService)this.context.getService(serviceReference);
        this.serviceReference = serviceReference;
        if (this.service != null) {
            this.configureService();
        }
    }

    private void removeService(ServiceReference<?> serviceReference) {
        if (serviceReference != this.serviceReference) {
            return;
        }
        this.unconfigureService();
        this.serviceReference = null;
        this.service = null;
    }

    private void unconfigureService() {
        this.service.unregister("/ca");
        this.service.unregister("/ca/resources");
        this.servlet.destroy();
        this.servlet = null;
        this.httpContext = null;
    }

    private void configureService() {
        logger.info("Configuring http service");
        this.httpContext = this.service.createDefaultHttpContext();
        try {
            this.service.registerResources("/ca/resources", "/resources", this.httpContext);
            this.servlet = new ListServlet(this.context);
            this.service.registerServlet("/ca", (Servlet)this.servlet, null, this.httpContext);
        }
        catch (NamespaceException e) {
            logger.warn("Failed to configure service", (Throwable)e);
        }
        catch (ServletException e) {
            logger.warn("Failed to configure service", (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.context.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.addService(event.getServiceReference());
                break;
            }
            case 4: {
                this.removeService(event.getServiceReference());
            }
        }
    }
}

