/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.changecounter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.buffer.BufferedDataSource;
import org.eclipse.scada.da.buffer.BufferedDataSourceListener;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.base.AbstractInputDataSource;
import org.eclipse.scada.da.datasource.changecounter.ChangeCounterEvaluator;
import org.eclipse.scada.da.datasource.changecounter.ChangeType;
import org.eclipse.scada.da.datasource.changecounter.ErrorHandling;
import org.eclipse.scada.da.datasource.data.DataItemValueRange;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;

public class ChangeCounterDataSource
extends AbstractInputDataSource
implements BufferedDataSourceListener,
SingleObjectPoolServiceTracker.ServiceListener<BufferedDataSource> {
    private final ScheduledExecutorService scheduler;
    private final ObjectPoolTracker<BufferedDataSource> poolTracker;
    private String bufferedDataSourceId;
    private ChangeType type;
    private List<Variant> values;
    private ErrorHandling errorHandling;
    private SingleObjectPoolServiceTracker<BufferedDataSource> objectPoolTracker;
    private BufferedDataSource bufferedDataSource;

    public ChangeCounterDataSource(ScheduledExecutorService scheduler, ObjectPoolTracker<BufferedDataSource> poolTracker) {
        this.scheduler = scheduler;
        this.poolTracker = poolTracker;
    }

    protected Executor getExecutor() {
        return this.scheduler;
    }

    public void update(Map<String, String> parameters) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.bufferedDataSourceId = cfg.getStringChecked("buffered.datasource.id", String.format("'%s' must be set", "buffered.datasource.id"));
        this.type = (ChangeType)cfg.getEnumChecked("type", ChangeType.class, "'type' must be set");
        this.errorHandling = (ErrorHandling)cfg.getEnum("onError", ErrorHandling.class, (Enum)ErrorHandling.ERROR);
        this.values = this.toVariants(cfg, "value");
        this.objectPoolTracker = new SingleObjectPoolServiceTracker(this.poolTracker, this.bufferedDataSourceId, (SingleObjectPoolServiceTracker.ServiceListener)this);
        this.objectPoolTracker.open();
    }

    private void sendUpdate(DataItemValueRange.DataItemValueRangeState dataItemValueRangeState) {
        if (this.values.isEmpty()) {
            this.updateData(new DataItemValue(Variant.valueOf((int)dataItemValueRangeState.getValues().size()), Collections.emptyMap(), SubscriptionState.CONNECTED));
        }
        try {
            int numOfChanges = 0;
            switch (this.type) {
                case DELTA: {
                    numOfChanges = ChangeCounterEvaluator.handleDelta(this.values, dataItemValueRangeState, this.errorHandling);
                    break;
                }
                case SET: {
                    numOfChanges = ChangeCounterEvaluator.handleSet(this.values, dataItemValueRangeState, this.errorHandling);
                    break;
                }
                case DIRECTION: {
                    numOfChanges = ChangeCounterEvaluator.handleDirection(this.values, dataItemValueRangeState, this.errorHandling);
                }
            }
            this.updateData(new DataItemValue(Variant.valueOf((int)numOfChanges), Collections.emptyMap(), SubscriptionState.CONNECTED));
        }
        catch (Exception exception) {
            HashMap<String, Variant> attr = new HashMap<String, Variant>();
            attr.put("org.eclipse.scada.da.datasource.changecounter.error", Variant.valueOf((boolean)true));
            this.updateData(new DataItemValue(Variant.NULL, attr, SubscriptionState.CONNECTED));
        }
    }

    public void stateChanged(DataItemValueRange dataItemValueRange) {
        this.sendUpdate(dataItemValueRange.getState());
    }

    private List<Variant> toVariants(ConfigurationDataHelper cfg, String name) {
        ArrayList<Variant> result = new ArrayList<Variant>();
        Map prefixed = cfg.getPrefixed(name);
        for (String v : prefixed.values()) {
            result.add(VariantEditor.toVariant((String)v));
        }
        return result;
    }

    public void dispose() {
        if (this.objectPoolTracker != null) {
            this.objectPoolTracker.close();
            this.objectPoolTracker = null;
        }
        this.setBufferedDataSource(null);
    }

    public void serviceChange(BufferedDataSource service, Dictionary<?, ?> properties) {
        this.setBufferedDataSource(service);
    }

    private synchronized void setBufferedDataSource(BufferedDataSource service) {
        if (service == null && this.bufferedDataSource != null) {
            this.bufferedDataSource.removeListener((BufferedDataSourceListener)this);
        } else {
            this.bufferedDataSource = service;
            this.bufferedDataSource.addListener((BufferedDataSourceListener)this);
        }
    }
}

