/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.movingaverage;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.movingaverage.MovingAverageDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovingAverageDataSourceFactory
extends AbstractServiceConfigurationFactory<MovingAverageDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(MovingAverageDataSourceFactory.class);
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<MovingAverageDataSource> avgObjectPool;
    private final ObjectPoolImpl<DataSource> dsObjectPool;
    private final ServiceRegistration<?> avgPoolRegistration;
    private final ServiceRegistration<?> dsPoolRegistration;

    public MovingAverageDataSourceFactory(BundleContext context, ExecutorService executor, ScheduledExecutorService scheduler) throws InvalidSyntaxException {
        super(context);
        this.executor = executor;
        this.scheduler = scheduler;
        this.avgObjectPool = new ObjectPoolImpl();
        this.avgPoolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.avgObjectPool, MovingAverageDataSource.class);
        this.dsObjectPool = new ObjectPoolImpl();
        this.dsPoolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.dsObjectPool, DataSource.class);
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class);
        this.poolTracker.open();
    }

    public synchronized void dispose() {
        this.dsPoolRegistration.unregister();
        this.avgPoolRegistration.unregister();
        this.dsObjectPool.dispose();
        this.avgObjectPool.dispose();
        this.poolTracker.close();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<MovingAverageDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        logger.debug("Creating new average source: {}", (Object)configurationId);
        MovingAverageDataSource avg = new MovingAverageDataSource(configurationId, this.executor, this.scheduler, this.poolTracker, this.dsObjectPool);
        avg.update(parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("datasource.id", configurationId);
        this.avgObjectPool.addService(configurationId, (Object)avg, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)avg);
    }

    protected void disposeService(UserInformation userInformation, String id, MovingAverageDataSource service) {
        logger.info("Disposing: {}", (Object)id);
        this.avgObjectPool.removeService(id, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<MovingAverageDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<MovingAverageDataSource> entry, Map<String, String> parameters) throws Exception {
        ((MovingAverageDataSource)entry.getService()).update(parameters);
        return null;
    }
}

