/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.proxy.internal;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.proxy.internal.ProxyDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class ProxyDataSourceFactory
extends AbstractServiceConfigurationFactory<ProxyDataSource> {
    private final ExecutorService executor;
    private final ObjectPoolTracker<DataSource> poolTracker;
    private final ObjectPoolImpl<DataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;

    public ProxyDataSourceFactory(BundleContext context) throws InvalidSyntaxException {
        super(context);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, DataSource.class);
        this.poolTracker = new ObjectPoolTracker(context, DataSource.class.getName());
        this.poolTracker.open();
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        this.poolTracker.close();
        super.dispose();
        this.executor.shutdown();
    }

    protected AbstractServiceConfigurationFactory.Entry<ProxyDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        ProxyDataSource dataSource = new ProxyDataSource(this.poolTracker, this.executor);
        dataSource.update(parameters);
        this.objectPool.addService(configurationId, (Object)dataSource, null);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)dataSource);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, ProxyDataSource service) {
        this.objectPool.removeService(configurationId, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ProxyDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ProxyDataSource> entry, Map<String, String> parameters) throws Exception {
        ((ProxyDataSource)((Object)entry.getService())).update(parameters);
        return null;
    }
}

