/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.totalizer;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.totalizer.TotalizerDataSourceFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private ScheduledExecutorService executor;
    private TotalizerDataSourceFactory factory;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.factory = new TotalizerDataSourceFactory(context, this.executor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "a totalizer");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", context.getBundle().getSymbolicName());
        context.registerService(ConfigurationFactory.class.getName(), (Object)this.factory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.factory != null) {
            this.factory.dispose();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        Activator.context = null;
    }
}

