/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.scale;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.AbstractCommonHandlerImpl;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;

public class ScaleHandlerImpl
extends AbstractCommonHandlerImpl {
    private boolean active = false;
    private double factor = 1.0;
    private double offset = 0.0;
    private final String attrActive = this.getPrefixed("active", Activator.getStringInterner());
    private final String attrFactor = this.getPrefixed("factor", Activator.getStringInterner());
    private final String attrOffset = this.getPrefixed("offset", Activator.getStringInterner());
    private final String attrValueOriginal = this.getPrefixed("value.original", Activator.getStringInterner());

    public ScaleHandlerImpl(String configurationId, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(configurationId, poolTracker, priority, caTracker, "org.eclipse.scada.da.scale.input", "org.eclipse.scada.da.scale.input");
    }

    @Override
    protected void processDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) throws Exception {
        this.injectAttributes(builder);
        builder.setAttribute(this.attrValueOriginal, builder.getValue());
        Variant val = builder.getValue();
        if (val == null || val.isNull()) {
            return;
        }
        builder.setValue(this.handleDataUpdate(builder.getValue()));
    }

    private Variant handleDataUpdate(Variant value) {
        if (!this.active) {
            return value;
        }
        return Variant.valueOf((double)(value.asDouble(null) * this.factor + this.offset));
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.factor = cfg.getDouble("factor", 1.0);
        this.offset = cfg.getDouble("offset", 0.0);
        this.active = cfg.getBoolean("active", false);
        this.reprocess();
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        builder.setAttribute(this.attrActive, this.active ? Variant.TRUE : Variant.FALSE);
        builder.setAttribute(this.attrFactor, Variant.valueOf((double)this.factor));
        builder.setAttribute(this.attrOffset, Variant.valueOf((double)this.offset));
    }

    protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        Variant active = attributes.get("active");
        Variant factor = attributes.get("factor");
        Variant offset = attributes.get("offset");
        if (active != null && !active.isNull()) {
            data.put("active", active.asString());
        }
        if (factor != null && !factor.isNull()) {
            data.put("factor", factor.asString());
        }
        if (offset != null && !offset.isNull()) {
            data.put("offset", offset.asString());
        }
        return this.updateConfiguration(data, attributes, false, operationParameters);
    }
}

