/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.io.common;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.eclipse.scada.da.server.io.common.ConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericBaseDevice
extends IoHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(GenericBaseDevice.class);
    protected final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void fireConnectionFailed(Throwable e) {
        logger.info("Connect failed", e);
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connectFailed(e);
        }
    }

    protected void fireDisconnected(Throwable e) {
        logger.info("Disconnected", e);
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connectFailed(e);
        }
    }

    protected void fireConnected() {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.opened();
        }
    }
}

