/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.modbus;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.da.server.common.io.JobManager;
import org.eclipse.scada.da.server.common.io.PollRequest;
import org.eclipse.scada.da.server.osgi.modbus.MasterFactory;
import org.eclipse.scada.da.server.osgi.modbus.ModbusMaster;
import org.eclipse.scada.da.server.osgi.modbus.ModbusRequestBlock;
import org.eclipse.scada.da.server.osgi.modbus.Request;
import org.eclipse.scada.da.server.osgi.modbus.RequestType;
import org.eclipse.scada.protocol.modbus.codec.ModbusProtocol;
import org.eclipse.scada.protocol.modbus.message.ReadRequest;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSlave
implements MasterFactory.Listener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSlave.class);
    private ModbusMaster master;
    private JobManager jobManager;
    private final BundleContext context;
    private byte slaveAddress;
    private String name;
    private final Map<String, ModbusRequestBlock> blocks = new HashMap<String, ModbusRequestBlock>();
    private final MasterFactory masterFactory;
    private String masterId;
    private final Executor executor;
    private final String id;
    private long timeoutQuietPeriod;
    private final AtomicInteger transactionId;

    public static ModbusSlave create(BundleContext context, Executor executor, String configurationId, Map<String, String> parameters, MasterFactory masterFactory, AtomicInteger transactionId) {
        ModbusSlave slave = new ModbusSlave(configurationId, context, masterFactory, executor, transactionId);
        slave.configure(parameters);
        return slave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModbusSlave(String id, BundleContext context, MasterFactory masterFactory, Executor executor, AtomicInteger transactionId) {
        this.id = id;
        this.executor = executor;
        this.context = context;
        this.masterFactory = masterFactory;
        this.transactionId = transactionId;
        ModbusSlave modbusSlave = this;
        synchronized (modbusSlave) {
            this.masterFactory.addMasterListener(this);
        }
    }

    public void dispose() {
        logger.info("Disposing block: {}", (Object)this.id);
        this.masterFactory.removeMasterListener(this);
        this.stop();
        for (ModbusRequestBlock block : this.blocks.values()) {
            block.dispose();
        }
        this.blocks.clear();
        logger.info("Block {} disposed", (Object)this.id);
    }

    protected synchronized void configure(Map<String, String> properties) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        this.name = cfg.getString("name", this.id);
        this.slaveAddress = Byte.parseByte(cfg.getStringChecked("slave.id", "'slave.id' must be set to a valid modbus slave id"));
        this.timeoutQuietPeriod = cfg.getLong("timeoutQuietPeriod", 10000L);
        ByteOrder dataOrder = ModbusProtocol.makeOrder((String)cfg.getString("dataOrder"), (ByteOrder)ByteOrder.BIG_ENDIAN);
        try {
            for (Map.Entry entry : cfg.getPrefixed("block.").entrySet()) {
                Request request = this.parseRequest((String)entry.getValue(), dataOrder);
                this.addBlock((String)entry.getKey(), request);
            }
            String newMasterId = cfg.getStringChecked("modbus.master.id", "'modbus.master.id' must be set to the id of a master device");
            if (!newMasterId.equals(this.masterId)) {
                logger.debug("setting new master id: {} -> {}", (Object)this.masterId, (Object)newMasterId);
                this.unbindMaster();
                this.masterId = newMasterId;
                this.masterFactory.resend(this);
            }
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
    }

    @Override
    public synchronized void masterAdded(String id, ModbusMaster master) {
        logger.debug("Master added: {}", (Object)id);
        if (id.equals(this.masterId)) {
            this.bindMaster(master);
        }
    }

    @Override
    public synchronized void masterRemoved(String id, ModbusMaster master) {
        logger.debug("Master removed: {}", (Object)id);
        if (id.equals(this.masterId)) {
            this.unbindMaster();
        }
    }

    private void bindMaster(ModbusMaster master) {
        if (this.master != null) {
            this.unbindMaster();
        }
        this.master = master;
        this.start(master, master.getJobManager());
    }

    private void unbindMaster() {
        this.stop();
    }

    private Request parseRequest(String value, ByteOrder dataOrder) {
        boolean eager;
        String periodString;
        String[] toks = value.split("\\:");
        if (toks.length != 6) {
            throw new IllegalArgumentException(String.format("Format must be 'functionCode:start:count:period:timeout:mainTypeName' = ( functionCode: %s )", new Object[]{RequestType.values()}));
        }
        int idx = 0;
        RequestType type = RequestType.valueOf(toks[idx++]);
        int startAddress = Integer.parseInt(toks[idx++]);
        int count = Integer.parseInt(toks[idx++]);
        if ((periodString = toks[idx++]).startsWith("+")) {
            eager = true;
            periodString = periodString.substring(1);
        } else {
            eager = false;
        }
        long period = Long.parseLong(periodString);
        long timeout = Long.parseLong(toks[idx++]);
        String mainTypeName = toks[idx++];
        return new Request(type, startAddress, count, period, timeout, mainTypeName, eager, dataOrder);
    }

    public synchronized void start(ModbusMaster master, JobManager jobManager) {
        logger.debug("Starting slave - slave: {}", (Object)this.name);
        this.master = master;
        this.jobManager = jobManager;
        for (Map.Entry<String, ModbusRequestBlock> entry : this.blocks.entrySet()) {
            this.jobManager.addBlock(this.makeBlockId(entry.getKey()), (PollRequest)entry.getValue());
        }
    }

    public synchronized void stop() {
        logger.debug("Stopping slave - slave: {}", (Object)this.name);
        if (this.jobManager == null) {
            return;
        }
        for (Map.Entry<String, ModbusRequestBlock> entry : this.blocks.entrySet()) {
            this.jobManager.removeBlock(this.makeBlockId(entry.getKey()));
        }
        this.master = null;
        this.jobManager = null;
    }

    protected synchronized void addBlock(String id, Request request) {
        logger.debug("Adding block: {}", (Object)id);
        this.removeBlock(id);
        ModbusRequestBlock block = new ModbusRequestBlock(this.executor, this.makeBlockId(id), this.name, request.getMainTypeName(), this, this.context, request, this.transactionId, true);
        this.blocks.put(id, block);
        if (this.jobManager != null) {
            this.jobManager.addBlock(this.makeBlockId(id), (PollRequest)block);
        }
    }

    private String makeBlockId(String id) {
        return String.valueOf(this.id) + "." + id;
    }

    protected synchronized void removeBlock(String id) {
        logger.trace("Removing block: {}", (Object)id);
        ModbusRequestBlock block = this.blocks.remove(id);
        if (block != null) {
            logger.debug("Removed block: {}", (Object)id);
            if (this.jobManager != null) {
                this.jobManager.removeBlock(this.makeBlockId(id));
            }
            block.dispose();
        }
    }

    public Object createPollRequest(int transactionId, Request request) {
        return new ReadRequest(transactionId, this.slaveAddress, request.getType().getReadFunctionCode(), request.getStartAddress(), request.getCount());
    }

    public byte getSlaveAddress() {
        return this.slaveAddress;
    }

    public void writeCommand(Object command, long timeout) {
        this.jobManager.addWriteRequest(command, timeout);
    }

    public long getTimeoutQuietPeriod() {
        return this.timeoutQuietPeriod;
    }
}

