/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.stock;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.stock.business.YahooStockQuoteService;
import org.eclipse.scada.da.server.stock.items.StockQuoteItem;
import org.eclipse.scada.da.server.stock.items.UpdateManager;
import org.eclipse.scada.utils.collection.MapBuilder;

public class Hive
extends HiveCommon {
    private static final int UPDATE_PERIOD = 30000;
    private ScheduledExecutorService scheduler;
    private final FolderCommon symbolsFolder;
    private final UpdateManager updateManager;

    public Hive() throws IOException {
        this.setValidatonStrategy(ValidationStrategy.GRANT_ALL);
        FolderCommon rootFolder = new FolderCommon();
        this.setRootFolder((Folder)rootFolder);
        this.symbolsFolder = new FolderCommon();
        rootFolder.add("symbols", (Folder)this.symbolsFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This folder contains the items by stock symbol")).getMap());
        this.updateManager = new UpdateManager();
        this.updateManager.setStockQuoteService(new YahooStockQuoteService());
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.stock";
    }

    protected void performStart() throws Exception {
        super.performStart();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Hive.this.updateManager.update();
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
        this.addSymbol("RHT");
        this.addSymbol("YHOO");
    }

    protected void performStop() throws Exception {
        this.scheduler.shutdown();
        super.performStop();
    }

    public void addSymbol(String symbol) {
        StockQuoteItem newItem = new StockQuoteItem(symbol, this.updateManager);
        this.registerItem((DataItem)newItem);
        this.symbolsFolder.add(symbol, (DataItem)newItem, new MapBuilder().getMap());
    }
}

