/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.net;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.core.server.net.AbstractServerConnectionHandler;
import org.eclipse.scada.hd.InvalidItemException;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.net.ItemListHelper;
import org.eclipse.scada.hd.net.QueryHelper;
import org.eclipse.scada.hd.server.Service;
import org.eclipse.scada.hd.server.Session;
import org.eclipse.scada.hd.server.net.QueryHandler;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.data.IntegerValue;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.net.utils.MessageCreator;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;

public class ServerConnectionHandler
extends AbstractServerConnectionHandler
implements ItemListListener {
    public static final String VERSION = "0.1.0";
    public static final int MAX_DATA_SIZE = Integer.getInteger("org.eclipse.scada.hd.server.net.maxDataSize", 1024);
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionHandler.class);
    private Service service = null;
    private Session session = null;
    private final Map<Long, QueryHandler> queries = new HashMap<Long, QueryHandler>();
    private final ExecutorService queryDisposer = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("ServerConnectionHandler/QueryDisposer"));

    public ServerConnectionHandler(Service service, IoSession ioSession, ConnectionInformation connectionInformation) {
        super(ioSession, connectionInformation);
        this.service = service;
        this.messenger.setHandler(65537, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.createSession(message);
            }
        });
        this.messenger.setHandler(65538, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.closeSession();
            }
        });
        this.messenger.setHandler(262161, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.setItemList(true);
            }
        });
        this.messenger.setHandler(262162, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.setItemList(false);
            }
        });
        this.messenger.setHandler(262145, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.handleCreateQuery(message);
            }
        });
        this.messenger.setHandler(262146, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.handleCloseQuery(message);
            }
        });
        this.messenger.setHandler(262147, new MessageListener(){

            public void messageReceived(Message message) {
                ServerConnectionHandler.this.handleUpdateQueryParameters(message);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateQueryParameters(Message message) {
        long queryId = ((LongValue)message.getValues().get("id")).getValue();
        QueryParameters parameters = QueryHelper.fromValue((Value)message.getValues().get("parameters"));
        logger.debug("Request parameter change: {}", (Object)parameters);
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            QueryHandler handler = this.queries.get(queryId);
            if (handler != null) {
                handler.changeParameters(parameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCloseQuery(Message message) {
        QueryHandler handler;
        Profiler p = new Profiler("Close Query");
        p.setLogger(logger);
        p.start("init");
        long queryId = ((LongValue)message.getValues().get("id")).getValue();
        logger.info("Handle close query: {}", (Object)queryId);
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            p.start("remove");
            this.sendQueryState(queryId, QueryState.DISCONNECTED);
            handler = this.queries.remove(queryId);
        }
        if (handler != null) {
            p.start("Close");
            this.queryDisposer.execute(new Runnable(){

                @Override
                public void run() {
                    handler.close();
                }
            });
        }
        p.stop().log();
    }

    protected void handleCreateQuery(Message message) {
        Profiler p = new Profiler("Create query");
        p.setLogger(logger);
        long queryId = ((LongValue)message.getValues().get("id")).getValue();
        logger.debug("Creating new query with id: {}", (Object)queryId);
        try {
            try {
                p.start("Prepare");
                String itemId = ((StringValue)message.getValues().get("itemId")).getValue();
                QueryParameters parameters = QueryHelper.fromValue((Value)message.getValues().get("parameters"));
                boolean updateData = message.getValues().containsKey("updateData");
                p.start("Make query");
                this.makeQuery(message, queryId, itemId, parameters, updateData);
                p.start("Finish");
            }
            catch (Throwable throwable) {
                this.sendQueryState(queryId, QueryState.DISCONNECTED);
                p.stop().log();
            }
        }
        finally {
            p.stop().log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeQuery(Message message, long queryId, String itemId, QueryParameters parameters, boolean updateData) throws InvalidSessionException, InvalidItemException {
        QueryHandler handler;
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            if (this.queries.containsKey(queryId)) {
                logger.warn("Duplicate query request: {}", (Object)queryId);
                this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Duplicate query id"));
                return;
            }
            handler = new QueryHandler(queryId, this);
            this.queries.put(queryId, handler);
        }
        Query query = this.service.createQuery(this.session, itemId, parameters, (QueryListener)handler, updateData);
        if (query == null) {
            ServerConnectionHandler serverConnectionHandler2 = this;
            synchronized (serverConnectionHandler2) {
                this.sendQueryState(queryId, QueryState.DISCONNECTED);
                this.queries.remove(queryId);
            }
        } else {
            logger.debug("Adding query: {}", (Object)queryId);
            handler.setQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueryData(long queryId, int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            if (!this.queries.containsKey(queryId)) {
                return;
            }
            int len = valueInformation.size();
            if (len < MAX_DATA_SIZE) {
                this.sendQueryDataPacket(queryId, index, values, valueInformation);
            } else {
                logger.debug("Using split send: {}", (Object)MAX_DATA_SIZE);
                int count = 0;
                do {
                    int size = Math.min(len - count, MAX_DATA_SIZE);
                    logger.debug("Sending - query-id: {}, index: {}, size: {}", new Object[]{queryId, count, size});
                    List<ValueInformation> vi = valueInformation.subList(count, count + size);
                    HashMap<String, List<Double>> v = new HashMap<String, List<Double>>();
                    for (Map.Entry<String, List<Double>> entry : values.entrySet()) {
                        List<Double> vs = entry.getValue().subList(count, count + size);
                        v.put(entry.getKey(), vs);
                    }
                    this.sendQueryDataPacket(queryId, count, v, vi);
                } while ((count += MAX_DATA_SIZE) < len);
            }
        }
    }

    private void sendQueryDataPacket(long queryId, int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
        logger.debug("Sending data - queryId: {}, index: {}, @values: {}, @informations: {}", new Object[]{queryId, index, values.size(), valueInformation.size()});
        Message message = new Message(262149);
        message.getValues().put("id", (Value)new LongValue(queryId));
        message.getValues().put("index", (Value)new IntegerValue(index));
        message.getValues().put("values", QueryHelper.toValueData(values));
        message.getValues().put("valueInformation", QueryHelper.toValueInfo(valueInformation));
        this.messenger.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueryParameters(long queryId, QueryParameters parameters, Set<String> valueTypes) {
        logger.debug("Sending query parameters: {} / {} / {}", new Object[]{queryId, parameters, valueTypes});
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            if (!this.queries.containsKey(queryId)) {
                return;
            }
            Message message = new Message(262150);
            message.getValues().put("id", (Value)new LongValue(queryId));
            message.getValues().put("parameters", QueryHelper.toValue((QueryParameters)parameters));
            message.getValues().put("valueTypes", QueryHelper.toValueTypes(valueTypes));
            this.messenger.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueryState(long queryId, QueryState state) {
        logger.debug("Sending query state: {} -> {}", new Object[]{queryId, state});
        ServerConnectionHandler serverConnectionHandler = this;
        synchronized (serverConnectionHandler) {
            if (!this.queries.containsKey(queryId)) {
                logger.info("Query not found {}", (Object)queryId);
                return;
            }
            Message message = new Message(262148);
            message.getValues().put("id", (Value)new LongValue(queryId));
            message.getValues().put("state", (Value)new StringValue(state.toString()));
            this.messenger.sendMessage(message);
        }
    }

    protected void setItemList(boolean flag) {
        if (flag) {
            this.session.setItemListListener((ItemListListener)this);
        } else {
            this.session.setItemListListener(null);
        }
    }

    private void createSession(final Message message) {
        if (this.session != null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"Connection already bound to a session"));
            return;
        }
        final Properties props = new Properties();
        MessageHelper.getProperties((Properties)props, (Value)message.getValues().get("properties"));
        String clientVersion = props.getProperty("client-version", "");
        if (clientVersion.equals("")) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"client does not pass \"client-version\" property! You may need to upgrade your client!"));
            return;
        }
        if (!clientVersion.equals(VERSION)) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)("protocol version mismatch: client '" + clientVersion + "' server: '" + VERSION + "'")));
            return;
        }
        this.service.createSession(props, this.createDefaultContext(), (CallbackHandler)new PropertiesCredentialsCallback(props)).addListener((FutureListener)new FutureListener<Session>(){

            public void complete(Future<Session> future) {
                ServerConnectionHandler.this.handleCreateSessionComplete(future, message, props);
            }
        });
    }

    protected void handleCreateSessionComplete(Future<Session> future, Message message, Properties props) {
        try {
            this.session = future.get();
        }
        catch (Exception e) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (Throwable)e));
            return;
        }
        if (this.session == null) {
            this.messenger.sendMessage(MessageCreator.createFailedMessage((Message)message, (String)"unable to create session"));
            return;
        }
        this.replySessionCreated(props, message, this.session.getProperties());
        this.session.addSessionListener(new Session.SessionListener(){

            public void privilegeChange() {
                ServerConnectionHandler.this.sendPrivilegeChange(ServerConnectionHandler.this.session.getPrivileges());
            }
        });
    }

    protected void cleanUp() {
        super.cleanUp();
        this.disposeSession();
    }

    private void disposeSession() {
        this.queryDisposer.shutdown();
        if (this.session != null) {
            Session session = this.session;
            this.session = null;
            try {
                this.service.closeSession((org.eclipse.scada.core.server.Session)session);
            }
            catch (InvalidSessionException e) {
                logger.warn("Failed to close session", (Throwable)e);
            }
        }
    }

    private void closeSession() {
        this.cleanUp();
    }

    public void listChanged(Set<HistoricalItemInformation> addedOrModified, Set<String> removed, boolean full) {
        Message message = new Message(262163);
        if (addedOrModified != null) {
            message.getValues().put("added", ItemListHelper.toValueAdded(addedOrModified));
        }
        if (removed != null) {
            message.getValues().put("removed", ItemListHelper.toValueRemoved(removed));
        }
        if (full) {
            message.getValues().put("full", (Value)VoidValue.INSTANCE);
        }
        this.messenger.sendMessage(message);
    }
}

