/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.sfp.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scada.protocol.sfp.messages.DataType;

public class BrowseUpdate {
    private final List<Entry> entries;

    public BrowseUpdate(List<Entry> entries) {
        this.entries = Collections.unmodifiableList(new ArrayList<Entry>(entries));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private final short register;
        private final String name;
        private final String description;
        private final String unit;
        private final DataType dataType;
        private final Set<Flags> flags;

        public Entry(short register, String name, String description, String unit, DataType dataType, Set<Flags> flags) {
            this.register = register;
            this.name = name;
            this.description = description;
            this.unit = unit;
            this.dataType = dataType;
            this.flags = Collections.unmodifiableSet(new HashSet<Flags>(flags));
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<Flags> getFlags() {
            return this.flags;
        }

        public String getName() {
            return this.name;
        }

        public short getRegister() {
            return this.register;
        }

        public String getUnit() {
            return this.unit;
        }

        public static enum Flags {
            INPUT,
            OUTPUT;

        }
    }
}

