/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.jdbc;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.UserManagerService;
import org.eclipse.scada.sec.provider.jdbc.JdbcAuthenticationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAuthenticationServiceFactory
extends AbstractServiceConfigurationFactory<JdbcAuthenticationService> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcAuthenticationServiceFactory.class);

    public JdbcAuthenticationServiceFactory(BundleContext context) {
        super(context);
    }

    protected AbstractServiceConfigurationFactory.Entry<JdbcAuthenticationService> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        logger.debug("Creating new service: {}", (Object)configurationId);
        JdbcAuthenticationService service = new JdbcAuthenticationService(context, configurationId);
        service.update(parameters);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "JDBC based authenticator");
        ((Dictionary)properties).put("service.pid", configurationId);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ServiceRegistration handle = service.isUserManager() ? context.registerService(new String[]{AuthenticationService.class.getName()}, (Object)service, properties) : context.registerService(new String[]{AuthenticationService.class.getName(), UserManagerService.class.getName()}, (Object)service, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service, handle);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, JdbcAuthenticationService service) {
        logger.debug("Disposing service: {}", (Object)configurationId);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<JdbcAuthenticationService> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<JdbcAuthenticationService> entry, Map<String, String> parameters) throws Exception {
        logger.debug("Updating service: {}", (Object)configurationId);
        ((JdbcAuthenticationService)entry.getService()).update(parameters);
        return null;
    }
}

