/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.injector;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.ae.server.injector.EventInjector;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventInjectorQueue {
    private static final Logger logger = LoggerFactory.getLogger(EventInjectorQueue.class);
    private final SingleServiceTracker<EventInjector> tracker;
    private EventInjector service;
    private final Queue<Entry> queue = new LinkedList<Entry>();

    public EventInjectorQueue(BundleContext context) {
        this.tracker = new SingleServiceTracker(context, EventInjector.class, (SingleServiceListener)new SingleServiceListener<EventInjector>(){

            public void serviceChange(ServiceReference<EventInjector> reference, EventInjector service) {
                EventInjectorQueue.this.handleServiceChange(service);
            }
        });
        logger.info("Opening tracker");
        this.tracker.open();
    }

    protected synchronized void handleServiceChange(EventInjector service) {
        this.service = service;
        if (service != null) {
            this.flushStoredEvents();
        }
    }

    private void flushStoredEvents() {
        Entry e;
        logger.debug("Flushing stored events: {}", (Object)this.queue.size());
        while ((e = this.queue.poll()) != null) {
            this.service.injectEvent(e.event, e.context);
        }
    }

    public synchronized void injectEvent(Event event, InjectionContext context) {
        logger.trace("Inject event: {}", (Object)event);
        if (this.service != null) {
            logger.trace("To service");
            this.service.injectEvent(event, context);
        } else {
            logger.trace("To queue");
            this.queue.offer(new Entry(event, context));
        }
    }

    public synchronized void dispose() {
        logger.info("Closing tracker");
        if (!this.queue.isEmpty()) {
            logger.warn("Discarding {} events", (Object)this.queue.size());
        }
        this.tracker.close();
    }

    private static final class Entry {
        Event event;
        InjectionContext context;

        public Entry(Event event, InjectionContext context) {
            this.event = event;
            this.context = context;
        }
    }
}

