/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.injector.monitor;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ae.server.injector.monitor.EventMonitor;
import org.eclipse.scada.ae.server.injector.monitor.EventMonitorEvaluator;
import org.eclipse.scada.ae.server.injector.monitor.EventMonitorImpl;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMonitorFactory
extends AbstractServiceConfigurationFactory<EventMonitor>
implements AknHandler,
EventMonitorEvaluator {
    public static final String FACTORY_ID = "ae.monitor.ae.event.external";
    private static final Logger logger = LoggerFactory.getLogger(EventMonitorFactory.class);
    private final Executor executor;
    private final ObjectPoolImpl<MonitorService> servicePool;
    private final EventProcessor eventProcessor;
    private final ConcurrentMap<String, EventMonitor> monitors = new ConcurrentHashMap<String, EventMonitor>();

    public EventMonitorFactory(BundleContext context, Executor executor, ObjectPoolImpl<MonitorService> servicePool, EventProcessor eventProcessor) {
        super(context);
        this.executor = executor;
        this.servicePool = servicePool;
        this.eventProcessor = eventProcessor;
    }

    protected AbstractServiceConfigurationFactory.Entry<EventMonitor> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        EventMonitorImpl instance = new EventMonitorImpl(context, this.executor, this.eventProcessor, configurationId);
        instance.update(userInformation, parameters);
        this.monitors.put(configurationId, instance);
        Hashtable properties = new Hashtable();
        this.servicePool.addService(configurationId, (Object)instance, properties);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)instance);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, EventMonitor service) {
        this.monitors.remove(configurationId);
        this.servicePool.removeService(configurationId, (Object)service);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<EventMonitor> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<EventMonitor> entry, Map<String, String> parameters) throws Exception {
        ((EventMonitor)entry.getService()).update(userInformation, parameters);
        return null;
    }

    public boolean acknowledge(String monitorId, OperationParameters operationParameters, Date aknTimestamp) {
        logger.debug("Try to process ACK: {}", (Object)monitorId);
        EventMonitor monitor = (EventMonitor)this.monitors.get(monitorId);
        if (monitor != null) {
            monitor.akn(operationParameters == null ? null : operationParameters.getUserInformation(), aknTimestamp);
            return true;
        }
        return false;
    }

    @Override
    public Event evaluate(Event event) {
        for (EventMonitor monitor : this.monitors.values()) {
            Pair<Boolean, Event> result = monitor.evaluate(event);
            if (!((Boolean)result.first).booleanValue()) continue;
            return (Event)result.second;
        }
        return event;
    }
}

