/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.Variable;
import org.osgi.framework.BundleContext;

public class UdtVariable
implements Variable {
    private final String name;
    private final Variable[] variables;
    private final int index;

    public UdtVariable(String name, int index, Variable ... variables) {
        this.name = name;
        this.index = index;
        this.variables = variables;
        if (variables == null) {
            throw new NullPointerException("'variables' must not be null");
        }
    }

    @Override
    public void handleData(IoBuffer data, Variant timestamp) {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.handleData(data, timestamp);
            ++n2;
        }
    }

    @Override
    public void handleError(int errorCode) {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.handleError(errorCode);
            ++n2;
        }
    }

    @Override
    public void handleDisconnect() {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.handleDisconnect();
            ++n2;
        }
    }

    @Override
    public void handleFailure(Throwable e) {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.handleFailure(e);
            ++n2;
        }
    }

    @Override
    public void start(String parentName, BundleContext context, MemoryRequestBlock block, int offset) {
        String itemId = parentName != null ? String.valueOf(parentName) + "." + this.name : this.name;
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.start(itemId, context, block, offset + this.index);
            ++n2;
        }
    }

    @Override
    public void stop(BundleContext context) {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.stop(context);
            ++n2;
        }
    }
}

