/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.common;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.server.storage.common.QueryBuffer;

public class UpdatableQueryBuffer
extends QueryBuffer {
    private final List<QueryBuffer.Entry> updateList = new LinkedList<QueryBuffer.Entry>();
    private final int updateListMax = Integer.getInteger("org.eclipse.scada.hd.server.storage.hds.updateListMax", 10);
    private final long updateTimeMax = Long.getLong("org.eclipse.scada.hd.server.storage.hds.updateTimeMax", 1000L);
    private ScheduledFuture<?> flushFuture;
    private final ScheduledExecutorService scheduledExecutor;

    public UpdatableQueryBuffer(QueryListener listener, ScheduledExecutorService executor, Date fixedStartDate, Date fixedEndDate) {
        super(listener, executor, fixedStartDate, fixedEndDate);
        this.scheduledExecutor = executor;
    }

    public synchronized void updateData(double value, Date timestamp, boolean error, boolean manual) {
        this.updateList.add(new QueryBuffer.Entry(value, timestamp, error, manual));
        if (this.updateList.size() > this.updateListMax) {
            this.flushUpdateQueue();
        } else if (this.flushFuture == null) {
            this.flushFuture = this.scheduledExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    UpdatableQueryBuffer.this.flushUpdateQueue();
                }
            }, this.updateTimeMax, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void flushUpdateQueue() {
        this.flushFuture = null;
        for (QueryBuffer.Entry entry : this.updateList) {
            this.insertData(entry);
        }
        this.updateList.clear();
        this.complete();
    }
}

