/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.chain;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.SuspendableDataItem;
import org.eclipse.scada.da.server.common.chain.ChainProcessEntry;
import org.eclipse.scada.da.server.common.chain.DataItemBaseChained;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public abstract class DataItemOutputChained
extends DataItemBaseChained
implements SuspendableDataItem {
    public DataItemOutputChained(DataItemInformation dataItemInformation, Executor executor) {
        super(dataItemInformation, executor);
    }

    public DataItemOutputChained(String id, Executor executor) {
        this(new DataItemInformationBase(id, EnumSet.of(IODirection.OUTPUT)), executor);
    }

    @Override
    public NotifyFuture<Variant> readValue() throws InvalidOperationException {
        throw new InvalidOperationException();
    }

    public synchronized void writeValue(Variant value) throws InvalidOperationException, NullValueException, NotConvertableException {
        Variant newValue = this.process(value);
        if (newValue != null) {
            this.writeCalculatedValue(newValue);
        }
    }

    @Override
    protected void process() {
        this.process(null);
    }

    protected Variant process(Variant value) {
        HashMap<String, Variant> primaryAttributes = new HashMap<String, Variant>(this.primaryAttributes);
        for (ChainProcessEntry entry : this.getChainCopy()) {
            Variant newValue;
            if (!entry.getWhen().contains(IODirection.OUTPUT) || (newValue = entry.getWhat().process(value, primaryAttributes)) == null) continue;
            value = newValue;
        }
        this.secondaryAttributes.set(null, primaryAttributes);
        return value;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void wakeup() {
        if (this.secondaryAttributes.get().size() > 0) {
            this.notifyData(null, this.secondaryAttributes.get());
        }
    }

    protected abstract void writeCalculatedValue(Variant var1) throws NullValueException, NotConvertableException;
}

