/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.exporter;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.exporter.ItemName;
import org.eclipse.scada.da.server.common.exporter.ItemOptions;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.utils.lang.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectExporter
implements Disposable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObjectExporter.class);
    protected ItemFactory factory;
    protected final Map<String, DataItem> items = new HashMap<String, DataItem>();
    protected final Map<String, Map<String, Variant>> attributes = new HashMap<String, Map<String, Variant>>();
    private final boolean readOnly;
    private final boolean nullIsError;
    private final String prefix;

    public AbstractObjectExporter(ItemFactory itemFactory, boolean readOnly, boolean nullIsError, String prefix) {
        this.factory = itemFactory;
        this.readOnly = readOnly;
        this.nullIsError = nullIsError;
        this.prefix = prefix;
    }

    public void dispose() {
        this.factory.dispose();
    }

    protected void createDataItems(Class<?> targetClazz) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(targetClazz);
            PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                DataItem item = this.createItem(pd, targetClazz);
                this.items.put(pd.getName(), item);
                HashMap<String, Variant> itemAttributes = new HashMap<String, Variant>();
                this.fillAttributes(pd, itemAttributes);
                this.attributes.put(pd.getName(), itemAttributes);
                this.initAttribute(pd);
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            logger.info("Failed to read initial item", (Throwable)e);
        }
    }

    protected void updateItemsFromTarget() {
        HashSet<String> updatedAttributes = new HashSet<String>();
        try {
            Object target = this.getTarget();
            if (target != null) {
                BeanInfo bi = Introspector.getBeanInfo(target.getClass());
                PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    updatedAttributes.add(pd.getName());
                    this.initAttribute(pd);
                    ++n2;
                }
            }
        }
        catch (IntrospectionException e) {
            logger.info("Failed to read item", (Throwable)e);
        }
        for (String key : this.items.keySet()) {
            if (updatedAttributes.contains(key)) continue;
            this.updateAttribute(key, null, null, this.getAdditionalAttributes());
        }
    }

    protected Map<String, Variant> getAdditionalAttributes() {
        return null;
    }

    protected void initAttribute(PropertyDescriptor pd) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        this.fillAttributes(pd, attributes);
        Map<String, Variant> additionalAttributes = this.getAdditionalAttributes();
        if (additionalAttributes != null) {
            attributes.putAll(additionalAttributes);
        }
        Object target = this.getTarget();
        Method m = pd.getReadMethod();
        if (m != null) {
            try {
                if (target != null) {
                    this.updateAttribute(pd.getName(), m.invoke(target, new Object[0]), null, attributes);
                } else {
                    this.updateAttribute(pd.getName(), null, null, attributes);
                }
            }
            catch (Throwable e) {
                this.updateAttribute(pd.getName(), null, e, attributes);
            }
        }
    }

    protected void fillAttributes(PropertyDescriptor pd, Map<String, Variant> attributes) {
        attributes.put("property.writeable", Variant.valueOf((pd.getWriteMethod() != null ? 1 : 0) != 0));
        attributes.put("property.readable", Variant.valueOf((pd.getReadMethod() != null ? 1 : 0) != 0));
        attributes.put("property.bound", Variant.valueOf((boolean)pd.isBound()));
        attributes.put("property.expert", Variant.valueOf((boolean)pd.isExpert()));
        attributes.put("property.constrained", Variant.valueOf((boolean)pd.isConstrained()));
        attributes.put("property.label", Variant.valueOf((Object)pd.getDisplayName()));
        attributes.put("property.type", Variant.valueOf((Object)pd.getPropertyType().getName()));
        attributes.put("property.name", Variant.valueOf((Object)pd.getName()));
        attributes.put("description", Variant.valueOf((Object)pd.getShortDescription()));
    }

    protected <T extends Annotation> T findAnnotation(PropertyDescriptor pd, Class<?> clazz, Class<T> annotationClazz) {
        String name = pd.getName();
        try {
            Field field = this.findField(name, clazz);
            T itemName = field.getAnnotation(annotationClazz);
            if (itemName != null) {
                return itemName;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (pd.getReadMethod() != null && pd.getReadMethod().getAnnotation(annotationClazz) != null) {
            return pd.getReadMethod().getAnnotation(annotationClazz);
        }
        if (pd.getWriteMethod() != null && pd.getWriteMethod().getAnnotation(annotationClazz) != null) {
            return pd.getWriteMethod().getAnnotation(annotationClazz);
        }
        return null;
    }

    protected ItemOptions getOptions(PropertyDescriptor pd, Class<?> clazz) {
        ItemOptions an = this.findAnnotation(pd, clazz, ItemOptions.class);
        if (an != null) {
            return an;
        }
        return new ItemOptions(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ItemOptions.class;
            }

            @Override
            public boolean readonly() {
                return false;
            }

            @Override
            public String description() {
                return "";
            }
        };
    }

    protected String makeItemName(PropertyDescriptor pd, Class<?> clazz) {
        try {
            ItemName itemName = this.findAnnotation(pd, clazz, ItemName.class);
            if (itemName == null) {
                return this.addPrefix(pd.getName());
            }
            return this.addPrefix(itemName.value());
        }
        catch (Exception exception) {
            return this.addPrefix(pd.getName());
        }
    }

    private String addPrefix(String name) {
        if (this.prefix == null) {
            return name;
        }
        return String.valueOf(this.prefix) + name;
    }

    private Field findField(String name, Class<?> clazz) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz == null || superClazz == Object.class) {
                throw new NoSuchFieldException(name);
            }
            return this.findField(name, superClazz);
        }
    }

    private DataItem createItem(final PropertyDescriptor pd, Class<?> clazz) {
        String itemName = this.makeItemName(pd, clazz);
        ItemOptions options = this.getOptions(pd, clazz);
        logger.debug("ItemOptions - {}", (Object)options);
        boolean writeable = !this.readOnly && pd.getWriteMethod() != null && !options.readonly();
        boolean readable = pd.getReadMethod() != null;
        HashMap<String, Variant> properties = new HashMap<String, Variant>();
        if (options.description() != null && !options.description().isEmpty()) {
            properties.put("description", Variant.valueOf((Object)options.description()));
        } else if (pd.getShortDescription() != null) {
            properties.put("description", Variant.valueOf((Object)pd.getShortDescription()));
        }
        if (writeable && readable) {
            return this.factory.createInputOutput(itemName, properties, new WriteHandler(){

                @Override
                public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                    AbstractObjectExporter.this.writeAttribute(pd, value);
                }
            });
        }
        if (readable) {
            return this.factory.createInput(itemName, properties);
        }
        if (writeable) {
            DataItemCommand item = this.factory.createCommand(itemName, properties);
            item.addListener(new DataItemCommand.Listener(){

                @Override
                public void command(Variant value) throws Exception {
                    AbstractObjectExporter.this.writeAttribute(pd, value);
                }
            });
            return item;
        }
        return null;
    }

    protected void updateAttribute(String propertyName, Object newValue, Throwable e, Map<String, Variant> additionalAttributes) {
        DataItem item = this.items.get(propertyName);
        if (item == null) {
            return;
        }
        if (item instanceof DataItemInputChained) {
            HashMap<String, Variant> attributes = new HashMap<String, Variant>();
            Map<String, Variant> itemAttributes = this.attributes.get(propertyName);
            if (itemAttributes != null) {
                attributes.putAll(itemAttributes);
            }
            if (additionalAttributes != null) {
                attributes.putAll(additionalAttributes);
            }
            if (e != null) {
                attributes.put("value.error", Variant.TRUE);
                attributes.put("value.error.message", Variant.valueOf((Object)e.getMessage()));
            }
            if (this.nullIsError && newValue == null) {
                attributes.put("null.error", Variant.TRUE);
            }
            DataItemInputChained inputItem = (DataItemInputChained)item;
            inputItem.updateData(Variant.valueOf((Object)newValue), attributes, AttributeMode.SET);
        }
    }

    protected abstract Object getTarget();

    protected void writeAttribute(PropertyDescriptor pd, Variant value) throws Exception {
        Method m = pd.getWriteMethod();
        if (m == null) {
            throw new RuntimeException("Failed to write since write method cannot be found");
        }
        Object target = this.getTarget();
        if (target == null) {
            throw new RuntimeException("No current target attached");
        }
        Class<?> targetType = pd.getPropertyType();
        Object o = this.convertWriteType(targetType, value);
        if (o != null) {
            m.invoke(target, o);
        } else {
            PropertyEditor pe = PropertyEditorManager.findEditor(targetType);
            pe.setAsText(value.asString());
        }
    }

    private Object convertWriteType(Class<?> targetType, Variant value) throws NullValueException, NotConvertableException {
        if (targetType.isAssignableFrom(Variant.class)) {
            return value;
        }
        if (value == null || value.isNull()) {
            return null;
        }
        if (targetType.isAssignableFrom(Long.class) || targetType.isAssignableFrom(Long.TYPE)) {
            return value.asLong();
        }
        if (targetType.isAssignableFrom(Integer.class) || targetType.isAssignableFrom(Integer.TYPE)) {
            return value.asInteger();
        }
        if (targetType.isAssignableFrom(Double.class) || targetType.isAssignableFrom(Double.TYPE)) {
            return value.asDouble();
        }
        if (targetType.isAssignableFrom(Boolean.class) || targetType.isAssignableFrom(Boolean.TYPE)) {
            return value.asBoolean();
        }
        if (targetType.isAssignableFrom(String.class)) {
            return value.asString();
        }
        return null;
    }
}

