/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.da.core.server.ItemChangeListener;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.core.server.browser.FolderListener;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.impl.DataItemSubscriptionListener;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.impl.SessionCommonData;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCommon
extends AbstractSessionImpl
implements Session,
DataItemSubscriptionListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionCommon.class);
    private final HiveCommon hive;
    private volatile ItemChangeListener listener;
    private final SessionCommonData data = new SessionCommonData();
    private volatile FolderListener folderListener;
    private boolean disposed;
    private final Collection<Future<?>> tasks = new ConcurrentLinkedQueue();

    public SessionCommon(HiveCommon hive, UserInformation userInformation, Map<String, String> properties) {
        super(userInformation, properties);
        this.hive = hive;
    }

    public HiveCommon getHive() {
        return this.hive;
    }

    public void setListener(ItemChangeListener listener) {
        this.listener = listener;
    }

    public ItemChangeListener getListener() {
        return this.listener;
    }

    public SessionCommonData getData() {
        return this.data;
    }

    public FolderListener getFolderListener() {
        return this.folderListener;
    }

    public void setListener(FolderListener folderListener) {
        this.folderListener = folderListener;
    }

    public void updateStatus(String topic, SubscriptionState subscriptionState) {
        ItemChangeListener listener = this.listener;
        if (listener != null) {
            listener.subscriptionChanged(topic, subscriptionState);
        }
    }

    @Override
    public void dataChanged(DataItem item, Variant value, Map<String, Variant> attributes, boolean cache) {
        logger.debug("Data changed - itemId: {}, value: {}, attributes: {}, cache: {}", new Object[]{item.getInformation().getName(), value, attributes, cache});
        ItemChangeListener listener = this.listener;
        if (listener != null) {
            listener.dataChanged(item.getInformation().getName(), value, attributes, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFuture(final NotifyFuture<?> future) throws InvalidSessionException {
        Collection<Future<?>> collection = this.tasks;
        synchronized (collection) {
            if (this.disposed) {
                throw new InvalidSessionException();
            }
            this.tasks.add((Future<?>)future);
        }
        future.addListener(new Runnable(){

            @Override
            public void run() {
                SessionCommon.this.removeFuture(future);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFuture(NotifyFuture<?> future) {
        Collection<Future<?>> collection = this.tasks;
        synchronized (collection) {
            if (!this.disposed) {
                this.tasks.remove(future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList tasks;
        Collection<Future<?>> collection = this.tasks;
        synchronized (collection) {
            this.disposed = true;
            tasks = new ArrayList(this.tasks);
            this.tasks.clear();
        }
        for (Future future : tasks) {
            try {
                future.cancel(false);
            }
            catch (Exception e) {
                logger.warn("Failed to cancel task", (Throwable)e);
            }
        }
    }
}

