/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.protocol.ngp.codec;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryProtocolDescriptor;
import org.eclipse.scada.core.ngp.common.codec.osbp.DefaultBinaryContext;
import org.eclipse.scada.core.protocol.ngp.codec.impl.CreateSession;
import org.eclipse.scada.core.protocol.ngp.codec.impl.RequestCallbacks;
import org.eclipse.scada.core.protocol.ngp.codec.impl.RespondCallbacks;
import org.eclipse.scada.core.protocol.ngp.codec.impl.SessionAccepted;
import org.eclipse.scada.core.protocol.ngp.codec.impl.SessionPrivilegesChanged;
import org.eclipse.scada.core.protocol.ngp.codec.impl.SessionRejected;

public final class ProtocolFactory {
    public static final String VERSION = "core.1";

    private ProtocolFactory() {
    }

    public static org.eclipse.scada.protocol.ngp.common.mc.protocol.ProtocolDescriptor createProtocolDescriptor() {
        return new ProtocolDescriptor();
    }

    public static org.eclipse.scada.protocol.ngp.common.mc.protocol.ProtocolDescriptor createProtocolDescriptor(BinaryContext binaryContext) {
        return new ProtocolDescriptor(binaryContext);
    }

    public static void fillCodecs(Collection<BinaryMessageCodec> codecs) {
        codecs.add(new CreateSession());
        codecs.add(new SessionAccepted());
        codecs.add(new SessionRejected());
        codecs.add(new SessionPrivilegesChanged());
        codecs.add(new RequestCallbacks());
        codecs.add(new RespondCallbacks());
    }

    private static final class ProtocolDescriptor
    extends BinaryProtocolDescriptor {
        public ProtocolDescriptor() {
            super((BinaryContext)new DefaultBinaryContext());
        }

        public ProtocolDescriptor(BinaryContext binaryContext) {
            super(binaryContext);
        }

        public String getProtocolId() {
            return String.valueOf(this.binaryContext.getProtocolIdPart()) + '/' + ProtocolFactory.VERSION;
        }

        protected Collection<BinaryMessageCodec> getCodecs() {
            LinkedList<BinaryMessageCodec> codecs = new LinkedList<BinaryMessageCodec>();
            ProtocolFactory.fillCodecs(codecs);
            return codecs;
        }
    }
}

