/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource;

import com.google.common.collect.Interner;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.utils.interner.InternerHelper;

public class MonitorStateInjector {
    private String prefix;
    private MonitorStatus state;
    private boolean active;
    private boolean akn;
    private boolean unsafe;
    private boolean alarm;
    private Severity severity;
    private final Interner<String> stringInterner;
    private String attributeActive;
    private String attributeState;
    private String attributeUnsafe;
    private String attributeInfo;
    private String attributeWarning;
    private String attributeAlarm;
    private String attributeError;
    private String attributeInfoAckRequired;
    private String attributeWarningAckRequired;
    private String attributeAlarmAckRequired;
    private String attributeErrorAckRequired;

    public MonitorStateInjector(Interner<String> stringInterner) {
        this.stringInterner = stringInterner == null ? InternerHelper.makeNoOpInterner() : stringInterner;
    }

    public void notifyStateChange(MonitorStatusInformation status) {
        this.state = status.getStatus();
        this.active = this.state != MonitorStatus.INACTIVE;
        this.akn = this.state == MonitorStatus.NOT_AKN || this.state == MonitorStatus.NOT_OK_NOT_AKN;
        this.unsafe = this.state == MonitorStatus.UNSAFE;
        this.alarm = this.state == MonitorStatus.NOT_OK || this.state == MonitorStatus.NOT_OK_AKN || this.state == MonitorStatus.NOT_OK_NOT_AKN;
        this.severity = status.getSeverity();
    }

    protected String intern(String value) {
        return (String)this.stringInterner.intern((Object)value);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.attributeActive = this.intern(String.valueOf(this.prefix) + ".active");
        this.attributeState = this.intern(String.valueOf(this.prefix) + ".state");
        this.attributeUnsafe = this.intern(String.valueOf(this.prefix) + ".unsafe");
        this.attributeInfo = this.intern(String.valueOf(this.prefix) + ".info");
        this.attributeWarning = this.intern(String.valueOf(this.prefix) + ".warning");
        this.attributeAlarm = this.intern(String.valueOf(this.prefix) + ".alarm");
        this.attributeError = this.intern(String.valueOf(this.prefix) + ".error");
        this.attributeInfoAckRequired = this.intern(String.valueOf(this.prefix) + ".info.ackRequired");
        this.attributeWarningAckRequired = this.intern(String.valueOf(this.prefix) + ".warning.ackRequired");
        this.attributeAlarmAckRequired = this.intern(String.valueOf(this.prefix) + ".alarm.ackRequired");
        this.attributeErrorAckRequired = this.intern(String.valueOf(this.prefix) + ".error.ackRequired");
    }

    public void injectAttributes(DataItemValue.Builder builder) {
        builder.setAttribute(this.attributeActive, Variant.valueOf((boolean)this.active));
        builder.setAttribute(this.attributeState, Variant.valueOf((Object)this.state));
        builder.setAttribute(this.attributeUnsafe, Variant.valueOf((boolean)this.unsafe));
        Severity severity = this.severity == null ? Severity.ALARM : this.severity;
        switch (severity) {
            case INFORMATION: {
                builder.setAttribute(this.attributeInfo, Variant.valueOf((boolean)this.alarm));
                builder.setAttribute(this.attributeInfoAckRequired, Variant.valueOf((boolean)this.akn));
                break;
            }
            case WARNING: {
                builder.setAttribute(this.attributeWarning, Variant.valueOf((boolean)this.alarm));
                builder.setAttribute(this.attributeWarningAckRequired, Variant.valueOf((boolean)this.akn));
                break;
            }
            case ALARM: {
                builder.setAttribute(this.attributeAlarm, Variant.valueOf((boolean)this.alarm));
                builder.setAttribute(this.attributeAlarmAckRequired, Variant.valueOf((boolean)this.akn));
                break;
            }
            case ERROR: {
                builder.setAttribute(this.attributeError, Variant.valueOf((boolean)this.alarm));
                builder.setAttribute(this.attributeErrorAckRequired, Variant.valueOf((boolean)this.akn));
            }
        }
    }
}

