/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.sfp;

import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.protocol.sfp.Sessions;
import org.eclipse.scada.protocol.sfp.messages.BrowseAdded;
import org.eclipse.scada.protocol.sfp.messages.DataType;
import org.eclipse.scada.protocol.sfp.messages.DataUpdate;
import org.eclipse.scada.protocol.sfp.messages.Hello;
import org.eclipse.scada.protocol.sfp.messages.ReadAll;
import org.eclipse.scada.protocol.sfp.messages.SubscribeBrowse;
import org.eclipse.scada.protocol.sfp.messages.UnsubscribeBrowse;
import org.eclipse.scada.protocol.sfp.messages.Welcome;
import org.eclipse.scada.protocol.sfp.messages.WriteCommand;
import org.eclipse.scada.protocol.sfp.messages.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDecoderImpl
extends CumulativeProtocolDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolDecoderImpl.class);
    private final Charset defaultCharset = Charset.forName("UTF-8");

    protected boolean doDecode(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws Exception {
        byte marker2;
        byte marker1;
        do {
            if (data.remaining() < 2) {
                return false;
            }
            marker1 = data.get(data.position() + 0);
            marker2 = data.get(data.position() + 1);
            if (marker1 == 18 && marker2 == 2) continue;
            data.skip(2);
        } while (marker1 != 18 || marker2 != 2);
        if (data.remaining() < 3) {
            return false;
        }
        data.order(Sessions.isLittleEndian(session) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        byte command = data.get(data.position() + 2);
        switch (command) {
            case 1: {
                return this.processHello(session, data, out);
            }
            case 2: {
                return this.processWelcome(session, data, out);
            }
            case 3: {
                out.write((Object)new ReadAll());
                return true;
            }
            case 4: {
                return this.processDataUpdate(session, data, out);
            }
            case 5: {
                out.write((Object)new SubscribeBrowse());
                return true;
            }
            case 6: {
                out.write((Object)new UnsubscribeBrowse());
                return true;
            }
            case 7: {
                return this.processBrowseAdded(session, data, out);
            }
            case 8: {
                return this.processWriteCommand(session, data, out);
            }
            case 9: {
                return this.processWriteResult(session, data, out);
            }
        }
        throw new ProtocolCodecException(String.format("Message code %02x is unkown", command));
    }

    private boolean processWriteCommand(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int len = this.messageLength(data);
        if (len < 0) {
            return false;
        }
        int registerNumber = data.getUnsignedShort();
        int operationId = data.getInt();
        Variant value = this.decodeVariant(session, data);
        out.write((Object)new WriteCommand(registerNumber, value, operationId));
        return true;
    }

    private boolean processWriteResult(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int len = this.messageLength(data);
        if (len < 0) {
            return false;
        }
        try {
            int operationId = data.getInt();
            int errorCode = data.getUnsignedShort();
            String errorMessage = this.decodeString(session, data);
            out.write((Object)new WriteResult(operationId, errorCode, errorMessage));
        }
        catch (CharacterCodingException e) {
            throw new ProtocolCodecException((Throwable)e);
        }
        return true;
    }

    private String decodeString(IoSession session, IoBuffer data) throws CharacterCodingException {
        String result = data.getPrefixedString(Sessions.getCharsetDecoder(session));
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private boolean processDataUpdate(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int len = this.messageLength(data);
        if (len < 0) {
            return false;
        }
        int count = data.getUnsignedShort();
        ArrayList<DataUpdate.Entry> entries = new ArrayList<DataUpdate.Entry>(count);
        int i = 0;
        while (i < count) {
            entries.add(this.decodeDataUpdateEntry(data, session));
            ++i;
        }
        out.write((Object)new DataUpdate(entries));
        return true;
    }

    private Variant decodeVariant(IoSession session, IoBuffer data) throws ProtocolCodecException {
        byte b = data.get();
        DataType dataType = DataType.fromByte(b);
        if (dataType == null) {
            throw new ProtocolCodecException(String.format("Data type %02x is unkown", b));
        }
        switch (dataType) {
            case DEAD: {
                return null;
            }
            case NULL: {
                return Variant.NULL;
            }
            case BOOLEAN: {
                return Variant.valueOf((data.get() != 0 ? 1 : 0) != 0);
            }
            case INT32: {
                return Variant.valueOf((int)data.getInt());
            }
            case INT64: {
                return Variant.valueOf((int)data.getInt());
            }
            case DOUBLE: {
                return Variant.valueOf((double)data.getDouble());
            }
            case STRING: {
                try {
                    return Variant.valueOf((Object)this.decodeString(session, data));
                }
                catch (CharacterCodingException e) {
                    throw new ProtocolCodecException((Throwable)e);
                }
            }
        }
        throw new ProtocolCodecException(String.format("Data type %s is unkown", b));
    }

    private DataUpdate.Entry decodeDataUpdateEntry(IoBuffer data, IoSession session) throws ProtocolCodecException {
        int register = data.getUnsignedShort();
        byte missedUpdates = data.get();
        long timestamp = data.getLong();
        EnumSet states = data.getEnumSetShort(DataUpdate.State.class);
        Variant value = this.decodeVariant(session, data);
        return new DataUpdate.Entry(register, value, timestamp, states, missedUpdates);
    }

    private boolean processWelcome(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int len = this.messageLength(data);
        if (len < 0) {
            return false;
        }
        EnumSet features = data.getEnumSetShort(Welcome.Features.class);
        CharsetDecoder decoder = this.defaultCharset.newDecoder();
        int count = data.getUnsignedShort();
        HashMap<String, String> properties = new HashMap<String, String>(count);
        int i = 0;
        while (i < count) {
            try {
                String key = data.getPrefixedString(decoder);
                String value = data.getPrefixedString(decoder);
                properties.put(key, value);
            }
            catch (CharacterCodingException e) {
                throw new ProtocolCodecException((Throwable)e);
            }
            ++i;
        }
        if (features.contains((Object)Welcome.Features.LITTLE_ENDIAN)) {
            logger.info("Setting little endian");
            Sessions.setLittleEndian(session);
        }
        out.write((Object)new Welcome(features, properties));
        return true;
    }

    private boolean processBrowseAdded(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int len = this.messageLength(data);
        if (len < 0) {
            return false;
        }
        int count = data.getUnsignedShort();
        ArrayList<BrowseAdded.Entry> entries = new ArrayList<BrowseAdded.Entry>(count);
        int i = 0;
        while (i < count) {
            entries.add(this.decodeBrowserAddEntry(data, session));
            ++i;
        }
        out.write((Object)new BrowseAdded(entries));
        return true;
    }

    private BrowseAdded.Entry decodeBrowserAddEntry(IoBuffer data, IoSession session) throws ProtocolCodecException {
        short register = (short)data.getUnsignedShort();
        byte b = data.get();
        DataType dataType = DataType.fromByte(b);
        if (dataType == null) {
            throw new ProtocolCodecException(String.format("Data type %s is unkown", b));
        }
        EnumSet flags = data.getEnumSet(BrowseAdded.Entry.Flags.class);
        CharsetDecoder decoder = Sessions.getCharsetDecoder(session);
        try {
            String name = data.getPrefixedString(decoder);
            String description = data.getPrefixedString(decoder);
            String unit = data.getPrefixedString(decoder);
            return new BrowseAdded.Entry(register, name, description, unit, dataType, flags);
        }
        catch (CharacterCodingException e) {
            throw new ProtocolCodecException((Throwable)e);
        }
    }

    private boolean processHello(IoSession session, IoBuffer data, ProtocolDecoderOutput out) throws ProtocolCodecException {
        int len = this.messageLength(data);
        if (len < 0) {
            return false;
        }
        byte version = data.get();
        if (version != 1) {
            throw new ProtocolCodecException(String.format("Protocol version %s is unsupported", version));
        }
        short nodeId = data.getShort();
        EnumSet features = data.getEnumSetShort(Hello.Features.class);
        out.write((Object)new Hello(nodeId, features));
        return true;
    }

    private int messageLength(IoBuffer data) {
        int len = data.getUnsignedShort(data.position() + 3);
        if (data.remaining() < 5 + len) {
            return -1;
        }
        data.skip(5);
        return len;
    }
}

