/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.monitor.proxy;

import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.monitor.proxy.AbstractMonitorQueryListener;
import org.eclipse.scada.ae.server.monitor.proxy.ProxyMonitorQuery;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.core.data.SubscriptionState;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteMonitorQueryListener
extends AbstractMonitorQueryListener
implements ConnectionTracker.Listener,
MonitorListener {
    private static final Logger logger = LoggerFactory.getLogger(RemoteMonitorQueryListener.class);
    private final ConnectionIdTracker tracker;
    private org.eclipse.scada.ae.connection.provider.ConnectionService connection;
    private final String monitorQueryId;

    public RemoteMonitorQueryListener(BundleContext context, String connectionId, String monitorQueryId, ProxyMonitorQuery proxyMonitorQuery, Lock lock) {
        super(proxyMonitorQuery, lock, String.valueOf(connectionId) + "#" + monitorQueryId);
        logger.info("Creating new listener - connection: {}, query: {}", (Object)connectionId, (Object)monitorQueryId);
        this.monitorQueryId = monitorQueryId;
        this.tracker = new ConnectionIdTracker(context, connectionId, (ConnectionTracker.Listener)this, org.eclipse.scada.ae.connection.provider.ConnectionService.class);
        this.tracker.open();
    }

    @Override
    public void dispose() {
        this.tracker.close();
        super.dispose();
    }

    public void setConnection(ConnectionService connectionService) {
        logger.debug("Setting connection: {}", (Object)connectionService);
        this.lock.lock();
        try {
            if (this.connection != null) {
                this.connection.getConnection().setMonitorListener(this.monitorQueryId, null);
                this.clearAll();
            }
            this.connection = (org.eclipse.scada.ae.connection.provider.ConnectionService)connectionService;
            if (this.connection != null) {
                this.connection.getConnection().setMonitorListener(this.monitorQueryId, (MonitorListener)this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void statusChanged(SubscriptionState state) {
        logger.info("State of {} changed: {}", (Object)this.info, (Object)state);
        switch (state) {
            case DISCONNECTED: 
            case GRANTED: {
                this.clearAll();
                break;
            }
        }
    }

    public void dataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        this.handleDataChanged(addedOrUpdated, removed, full);
    }
}

