/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.component;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.subscription.SubscriptionManagerListener;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.osgi.AbstractOsgiHiveCommon;
import org.eclipse.scada.da.server.component.Component;
import org.eclipse.scada.da.server.component.ComponentFactory;
import org.eclipse.scada.da.server.component.ComponentFolder;
import org.eclipse.scada.da.server.component.ComponentHandle;
import org.eclipse.scada.da.server.component.ComponentHost;
import org.eclipse.scada.da.server.component.ComponentNode;
import org.eclipse.scada.da.server.component.osgi.OsgiFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive
extends AbstractOsgiHiveCommon
implements ComponentHost {
    private static final Logger logger = LoggerFactory.getLogger(Hive.class);
    private final FolderCommon rootFolder = new FolderCommon();
    private Component component;
    private ComponentNode rootNode;
    private OsgiFactory osgiFactory;

    public Hive(BundleContext context, Executor executor) {
        super(context, executor);
        this.setValidatonStrategy(ValidationStrategy.GRANT_ALL);
        this.setRootFolder((Folder)this.rootFolder);
    }

    @Override
    public void addItemSubscriptionListener(SubscriptionManagerListener<String> listener) {
        super.addItemSubscriptionListener(listener);
    }

    @Override
    public void removeItemSubscriptionListener(SubscriptionManagerListener<String> listener) {
        super.removeItemSubscriptionListener(listener);
    }

    protected void performStart() throws Exception {
        super.performStart();
        FolderCommon rootNodeFolder = new FolderCommon();
        this.rootFolder.add("components", (Folder)rootNodeFolder, null);
        this.rootNode = new ComponentNode(null, rootNodeFolder);
        this.osgiFactory = new OsgiFactory(FrameworkUtil.getBundle(Hive.class).getBundleContext(), this);
    }

    protected void performStop() throws Exception {
        this.osgiFactory.dispose();
        this.rootFolder.remove("components");
        this.rootNode = null;
        if (this.component != null) {
            this.component.dispose();
            this.component = null;
        }
        super.performStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentHandle registerComponent(ComponentFactory componentFactory) throws Exception {
        logger.debug("Register component: {}", (Object)componentFactory);
        String[] prefix = componentFactory.getPrefix();
        ComponentFolder folder = new ComponentFolder();
        Component component = componentFactory.createComponent(this, folder.getFolderImpl());
        folder.setComponent(component);
        try {
            Hive hive = this;
            synchronized (hive) {
                return this.performRegisterComponent(prefix, folder, component);
            }
        }
        catch (Exception e) {
            logger.info("Failed to register new component", (Throwable)e);
            component.dispose();
            throw e;
        }
    }

    private synchronized ComponentHandle performRegisterComponent(final String[] prefix, ComponentFolder folder, final Component component) {
        logger.debug("Register new component - prefix: {}, folder: {}, component: {}", new Object[]{prefix, folder, component});
        this.rootNode.registerComponent(new LinkedList<String>(Arrays.asList(prefix)), folder, component);
        return new ComponentHandle(){

            @Override
            public void unregister() {
                Hive.this.performUnregister(prefix, component);
            }
        };
    }

    private synchronized void performUnregister(String[] prefix, Component component) {
        logger.debug("Perform unregister component - prefix: {}, component: {}", (Object)prefix, (Object)component);
        try {
            this.rootNode.unregisterComponent(new LinkedList<String>(Arrays.asList(prefix)), component);
        }
        finally {
            component.dispose();
        }
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.component";
    }
}

