/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.common.osgi.factory.ObjectPoolDataItemFactory;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.StaticHiveSource;
import org.eclipse.scada.da.server.exporter.modbus.ModbusExport;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceDefinition;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceType;

public class StaticModbusExport
extends ModbusExport {
    private final ScheduledExecutorService executor;
    private final boolean disposeProcessor;
    private final IoProcessor<NioSession> processor;

    private StaticModbusExport(ScheduledExecutorService executor, IoProcessor<NioSession> processor, HiveSource hiveSource, ObjectPoolDataItemFactory itemFactory, boolean disposeProcessor) {
        super(executor, processor, hiveSource, itemFactory);
        this.executor = executor;
        this.processor = processor;
        this.disposeProcessor = disposeProcessor;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.disposeProcessor) {
            this.processor.dispose();
        }
        this.executor.shutdown();
    }

    /* synthetic */ StaticModbusExport(ScheduledExecutorService scheduledExecutorService, IoProcessor ioProcessor, HiveSource hiveSource, ObjectPoolDataItemFactory objectPoolDataItemFactory, boolean bl, StaticModbusExport staticModbusExport) {
        this(scheduledExecutorService, (IoProcessor<NioSession>)ioProcessor, hiveSource, objectPoolDataItemFactory, bl);
    }

    public static class Builder {
        private final HiveSource hiveSource;
        private ThreadFactory threadFactory;
        private IoProcessor<NioSession> processor;
        private Properties hiveProperies = new Properties();
        private int readTimeout = 30000;
        private int port = 1502;
        private short slaveId = 1;
        private List<SourceDefinition> definitions = new LinkedList<SourceDefinition>();

        public Builder(Hive hive) {
            this.hiveSource = new StaticHiveSource(hive);
        }

        public void setHiveProperies(Properties hiveProperies) {
            this.hiveProperies = hiveProperies;
        }

        public void setReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException(String.format("'readTimeout' must not be negative or zero", new Object[0]));
            }
            this.readTimeout = readTimeout;
        }

        public void setPort(int port) {
            if (port <= 0 || port >= 65535) {
                throw new IllegalArgumentException(String.format("'port' must be between 0 (exclusive) and 0xFFFF (exclusive) but is %s", port));
            }
            this.port = port;
        }

        public void setSlaveId(short slaveId) {
            if (slaveId <= 0 || slaveId >= 255) {
                throw new IllegalArgumentException(String.format("'slaveId' must be between 0 (exclusive) and 0xFFFF (exclusive) but is %s", slaveId));
            }
            this.slaveId = slaveId;
        }

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public void setIoProcessor(IoProcessor<NioSession> processor) {
            this.processor = processor;
        }

        public void setDefinitions(Collection<SourceDefinition> definitions) {
            this.definitions = definitions != null ? new LinkedList<SourceDefinition>(definitions) : new LinkedList<SourceDefinition>();
        }

        public void addExport(String itemId, int offset, SourceType type) {
            if (itemId == null) {
                throw new IllegalArgumentException(String.format("'itemId' must not be null", new Object[0]));
            }
            if (offset < 0) {
                throw new IllegalArgumentException(String.format("'offset' must not be negative (%s)", offset));
            }
            if (offset >= 65535) {
                throw new IllegalArgumentException(String.format("'offset' be less then 0xFFFF (%s)", offset));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("'type' must not be null", new Object[0]));
            }
            this.definitions.add(new SourceDefinition(itemId, offset, type));
        }

        public ModbusExport build() {
            boolean disposeProcessor;
            SimpleIoProcessorPool processor;
            ScheduledExecutorService executor = this.threadFactory == null ? Executors.newScheduledThreadPool(1) : Executors.newScheduledThreadPool(1, this.threadFactory);
            if (this.processor == null) {
                processor = new SimpleIoProcessorPool(NioProcessor.class);
                disposeProcessor = true;
            } else {
                processor = this.processor;
                disposeProcessor = false;
            }
            StaticModbusExport result = new StaticModbusExport(executor, (IoProcessor)processor, this.hiveSource, null, disposeProcessor, null);
            try {
                result.setProperties(this.hiveProperies);
                result.setReadTimeout(this.readTimeout);
                result.setSlaveId(this.slaveId);
                result.setPort(this.port);
                result.setBlockConfiguration(this.definitions);
                return result;
            }
            catch (Throwable e) {
                result.dispose();
                throw new RuntimeException("Failed to start exporter", e);
            }
        }
    }
}

