/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceType;

public class UnsignedShortIntegerType
extends AbstractSourceType {
    private final Double factor;
    private static final int DATA_LENGTH = 2;
    public static final int LENGTH = 12;
    public static final SourceType INSTANCE = new UnsignedShortIntegerType();

    public UnsignedShortIntegerType(Double factor) {
        super(2);
        this.factor = factor;
    }

    public UnsignedShortIntegerType() {
        this(null);
    }

    @Override
    public void putValue(IoBuffer slice, Variant value) {
        slice.putUnsignedShort(this.makeValue(value));
    }

    @Override
    public Variant getValue(int localOffset, IoBuffer value) {
        if (localOffset == 10 && value.remaining() == 2) {
            return Variant.valueOf((int)value.getUnsignedShort());
        }
        return null;
    }

    private int makeValue(Variant value) {
        if (value == null) {
            return 0;
        }
        if (this.factor == null) {
            Integer v = value.asInteger(null);
            if (v == null) {
                return 0;
            }
            return v;
        }
        Double v = value.asDouble(null);
        if (v == null) {
            return 0;
        }
        return (int)(this.factor * v);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsignedShortIntegerType)) {
            return false;
        }
        UnsignedShortIntegerType other = (UnsignedShortIntegerType)obj;
        return !(this.factor == null ? other.factor != null : !this.factor.equals(other.factor));
    }
}

