/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.iec60870.cfg;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.common.iec60870.Configurations;
import org.eclipse.scada.da.server.iec60870.ConnectionConfiguration;
import org.eclipse.scada.da.server.iec60870.cfg.ConfigurationFactory;
import org.eclipse.scada.protocol.iec60870.ProtocolOptions;
import org.eclipse.scada.protocol.iec60870.client.data.DataModuleOptions;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAConfigurationFactory
implements ConfigurationFactory,
org.eclipse.scada.ca.ConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(CAConfigurationFactory.class);
    private ConfigurationFactory.Receiver receiver;
    private final ServiceRegistration<org.eclipse.scada.ca.ConfigurationFactory> handle;
    private final Map<String, ConnectionConfiguration> configurations = new HashMap<String, ConnectionConfiguration>();

    public CAConfigurationFactory(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.iec60870.connection");
        ((Dictionary)properties).put("service.description", "IEC60870-5-104 connection");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        this.handle = context.registerService(org.eclipse.scada.ca.ConfigurationFactory.class, (Object)this, properties);
    }

    public synchronized void dispose() {
        this.handle.unregister();
        this.configurations.clear();
    }

    @Override
    public synchronized void setReceiver(ConfigurationFactory.Receiver receiver) {
        logger.debug("Setting receiver: {}", (Object)receiver);
        this.receiver = receiver;
        if (receiver != null) {
            logger.debug("Pushing stored configuration");
            for (Map.Entry<String, ConnectionConfiguration> entry : this.configurations.entrySet()) {
                logger.debug("\t{}", (Object)entry.getKey());
                receiver.addConnection(entry.getKey(), entry.getValue());
            }
        }
    }

    private ConnectionConfiguration parse(Map<String, String> properties) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        String host = cfg.getStringNonEmptyChecked("host", "'host' must be set");
        int port = cfg.getInteger("port", 2404);
        ProtocolOptions.Builder builder = Configurations.parseProtocolOptions((ConfigurationDataHelper)cfg.getPrefixedHelper("protocol"));
        DataModuleOptions dataModuleOptions = this.parseDataModuleOptions(cfg.getPrefixedHelper("dataModule"));
        return new ConnectionConfiguration(host, port, builder.build(), dataModuleOptions);
    }

    private DataModuleOptions parseDataModuleOptions(ConfigurationDataHelper cfg) {
        DataModuleOptions.Builder builder = new DataModuleOptions.Builder();
        builder.setIgnoreBackgroundScan(cfg.getBoolean("ignoreBackgroundScan", true));
        return builder.build();
    }

    public synchronized void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        logger.debug("Request to update configuration: {}", (Object)configurationId);
        this.delete(userInformation, configurationId);
        ConnectionConfiguration cfg = this.parse(properties);
        this.configurations.put(configurationId, cfg);
        logger.debug("Configuration cached internally: {}", (Object)cfg);
        if (this.receiver != null) {
            logger.debug("Forwarding update to receiver");
            this.receiver.addConnection(configurationId, cfg).get();
        }
    }

    public synchronized void delete(UserInformation userInformation, String configurationId) throws Exception {
        logger.debug("Request to delete configuration: {}", (Object)configurationId);
        if (this.receiver != null) {
            logger.debug("Forwarding deletion to receiver");
            this.receiver.removeConnection(configurationId);
        }
        this.configurations.remove(configurationId);
    }
}

