/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.summary;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.base.AbstractInputDataSource;
import org.eclipse.scada.utils.osgi.pool.AllObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceSummarizer
extends AbstractInputDataSource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataSourceSummarizer.class);
    private final AllObjectPoolServiceTracker<DataSource> tracker;
    private final Map<DataSource, DataSourceListenerImpl> listeners = new HashMap<DataSource, DataSourceListenerImpl>();
    private final Executor executor;

    public AbstractDataSourceSummarizer(Executor executor, ObjectPoolTracker<DataSource> tracker) {
        this.executor = executor;
        this.tracker = new AllObjectPoolServiceTracker(tracker, (ObjectPoolListener)new ObjectPoolListener<DataSource>(){

            public void serviceAdded(DataSource service, Dictionary<?, ?> properties) {
                if (!(service instanceof DataSource)) {
                    return;
                }
                if (service == AbstractDataSourceSummarizer.this) {
                    return;
                }
                if (!AbstractDataSourceSummarizer.this.isMatch(service, properties)) {
                    return;
                }
                AbstractDataSourceSummarizer.this.handleAdded(service, properties);
            }

            public void serviceModified(DataSource service, Dictionary<?, ?> properties) {
            }

            public void serviceRemoved(DataSource service, Dictionary<?, ?> properties) {
                if (!(service instanceof DataSource)) {
                    return;
                }
                if (service == AbstractDataSourceSummarizer.this) {
                    return;
                }
                AbstractDataSourceSummarizer.this.handleRemoved(service, properties);
            }
        });
    }

    protected boolean isMatch(DataSource service, Dictionary<?, ?> properties) {
        return true;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    protected synchronized void handleAdded(DataSource service, Dictionary<?, ?> properties) {
        logger.debug("Adding datasource {}", (Object)service);
        if (this.listeners.containsKey(service)) {
            return;
        }
        DataSourceListenerImpl listener = new DataSourceListenerImpl(service);
        this.handleAdding(service);
        this.listeners.put(service, listener);
        service.addListener((DataSourceListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRemoved(DataSource service, Dictionary<?, ?> properties) {
        DataSourceListenerImpl listener;
        AbstractDataSourceSummarizer abstractDataSourceSummarizer = this;
        synchronized (abstractDataSourceSummarizer) {
            listener = this.listeners.remove(service);
            if (listener != null) {
                service.removeListener((DataSourceListener)listener);
            }
        }
        if (listener != null) {
            listener.dispose();
        }
    }

    protected abstract void handleAdding(DataSource var1);

    protected abstract void handleRemoved(DataSource var1);

    protected abstract void handleStateChange(DataSource var1, DataItemValue var2);

    private class DataSourceListenerImpl
    implements DataSourceListener {
        private final DataSource source;
        private boolean disposed;

        public DataSourceListenerImpl(DataSource source) {
            this.source = source;
        }

        public synchronized void stateChanged(DataItemValue value) {
            logger.debug("State change: {}", (Object)value);
            if (!this.disposed) {
                AbstractDataSourceSummarizer.this.handleStateChange(this.source, value);
            }
        }

        public synchronized void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                AbstractDataSourceSummarizer.this.handleRemoved(this.source);
            }
        }
    }
}

