/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.item;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.proxy.item.ProxyItemSupport;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.eclipse.scada.da.server.proxy.utils.ProxySubConnectionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyValueHolder
extends ProxyItemSupport {
    private static final Logger logger = LoggerFactory.getLogger(ProxyValueHolder.class);
    protected final Map<ProxySubConnectionId, DataItemValue.Builder> values = new HashMap<ProxySubConnectionId, DataItemValue.Builder>();
    protected ItemUpdateListener listener = null;

    public ProxyValueHolder(String separator, ProxyPrefixName prefix, ProxySubConnectionId currentConnection, String itemId) {
        super(separator, prefix, currentConnection, itemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchTo(ProxySubConnectionId newConnection) {
        ProxyValueHolder proxyValueHolder = this;
        synchronized (proxyValueHolder) {
            DataItemValue.Builder oldData = this.getItemValue(this.currentConnection);
            DataItemValue.Builder newData = this.getItemValue(newConnection);
            if (!oldData.equals(newData)) {
                if (newData.getValue() != null && !newData.getValue().equals((Object)oldData.getValue())) {
                    this.listener.notifyDataChange(newData.getValue(), newData.getAttributes(), true);
                } else if (newData.getAttributes() != null && !newData.getAttributes().equals(oldData.getAttributes())) {
                    this.listener.notifyDataChange(newData.getValue(), newData.getAttributes(), true);
                }
            }
            super.switchTo(newConnection);
        }
    }

    public void updateData(ProxySubConnectionId connection, Variant value, Map<String, Variant> attributes, AttributeMode mode) {
        try {
            this.handleUpdateData(connection, value, attributes, mode);
        }
        catch (Throwable e) {
            logger.error(String.format("Failed to update data of item '%s'", this.proxyItemId), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateData(ProxySubConnectionId connection, Variant value, Map<String, Variant> attributes, AttributeMode mode) {
        boolean doSend;
        ProxyValueHolder proxyValueHolder = this;
        synchronized (proxyValueHolder) {
            boolean changed = false;
            DataItemValue.Builder div = this.getItemValue(connection);
            if (value != null && !div.getValue().equals((Object)value)) {
                div.setValue(value);
                changed = true;
            }
            if (attributes != null) {
                if (mode == null) {
                    mode = AttributeMode.UPDATE;
                }
                HashMap diff = new HashMap();
                if (mode == AttributeMode.SET) {
                    AttributesHelper.set((Map)div.getAttributes(), attributes, diff);
                } else {
                    AttributesHelper.mergeAttributes((Map)div.getAttributes(), attributes, diff);
                }
                changed = changed || !diff.isEmpty();
            }
            doSend = connection.equals(this.currentConnection);
        }
        if (doSend) {
            this.listener.notifyDataChange(value, attributes, false);
        }
    }

    protected DataItemValue.Builder getItemValue(ProxySubConnectionId id) {
        DataItemValue.Builder div = this.values.get(id);
        if (div == null) {
            logger.debug("Creating item value for {} on connection {}", (Object)this.proxyItemId, (Object)id.getName());
            div = new DataItemValue.Builder();
            this.values.put(id, div);
        }
        return div;
    }

    public Map<String, Variant> getAttributes() {
        DataItemValue.Builder div = this.values.get(this.currentConnection);
        return div.getAttributes();
    }

    public Variant getValue() {
        DataItemValue.Builder div = this.values.get(this.currentConnection);
        return div.getValue();
    }

    public void setListener(ItemUpdateListener listener) {
        this.listener = listener;
    }

    public void updateSubscriptionState(ProxySubConnectionId connection, SubscriptionState subscriptionState, Throwable subscriptionError) {
        try {
            this.handleUpdateSubscriptionChange(connection, subscriptionState, subscriptionError);
        }
        catch (Throwable e) {
            logger.error(String.format("Failed to change subscription state of item '%s'", this.proxyItemId), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateSubscriptionChange(ProxySubConnectionId connection, SubscriptionState subscriptionState, Throwable subscriptionError) {
        boolean doSend;
        ProxyValueHolder proxyValueHolder = this;
        synchronized (proxyValueHolder) {
            DataItemValue.Builder div = this.getItemValue(connection);
            div.setSubscriptionState(subscriptionState);
            div.setSubscriptionError(subscriptionError);
            doSend = connection.equals(this.currentConnection);
        }
        if (doSend) {
            this.listener.notifySubscriptionChange(subscriptionState, subscriptionError);
        }
    }

    public DataItemValue getCurrentValue() {
        return this.values.get(this.currentConnection).build();
    }
}

