/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.internal;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.osgi.internal.HiveImpl;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.osgi.pool.AllObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private HiveImpl service;
    private ServiceRegistration<Hive> handle;
    private ServiceListener listener;
    private ObjectPoolTracker<DataItem> poolTracker;
    private AllObjectPoolServiceTracker<DataItem> itemTracker;
    private ExportedExecutorService executor;

    public void start(BundleContext context) throws Exception {
        this.executor = new ExportedExecutorService("org.eclipse.scada.da.server.osgi", 1, 1, 1L, TimeUnit.MINUTES);
        this.service = new HiveImpl(context, (Executor)this.executor);
        this.service.start();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A common generic OSGi DA Hive");
        ((Dictionary)properties).put("hive.id", this.service.getHiveId());
        this.handle = context.registerService(Hive.class, (Object)this.service, properties);
        this.listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        Activator.this.addItem(event.getServiceReference());
                        break;
                    }
                    case 4: {
                        Activator.this.removeItem(event.getServiceReference());
                    }
                }
            }
        };
        context.addServiceListener(this.listener, "(objectClass=" + DataItem.class.getName() + ")");
        Collection refs = context.getServiceReferences(DataItem.class, null);
        if (refs != null) {
            for (ServiceReference ref : refs) {
                this.addItem(ref);
            }
        }
        this.poolTracker = new ObjectPoolTracker(context, DataItem.class);
        this.poolTracker.open();
        this.itemTracker = new AllObjectPoolServiceTracker(this.poolTracker, (ObjectPoolListener)new ObjectPoolListener<DataItem>(){

            public void serviceRemoved(DataItem service, Dictionary<?, ?> properties) {
                Activator.this.service.removeItem(service);
            }

            public void serviceModified(DataItem service, Dictionary<?, ?> properties) {
            }

            public void serviceAdded(DataItem service, Dictionary<?, ?> properties) {
                Activator.this.service.addItem(service, properties);
            }
        });
        this.itemTracker.open();
    }

    protected void removeItem(ServiceReference<?> serviceReference) {
        this.service.removeItem(serviceReference);
    }

    protected void addItem(ServiceReference<?> serviceReference) {
        this.service.addItem(serviceReference);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeServiceListener(this.listener);
        this.itemTracker.close();
        this.poolTracker.close();
        this.handle.unregister();
        this.handle = null;
        this.service.stop();
        this.service = null;
        this.executor.shutdown();
    }
}

