/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.slave.inject;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ae.slave.inject.JdbcStorageDao;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventInjector {
    private static final Logger logger = LoggerFactory.getLogger(EventInjector.class);
    private final JdbcStorageDao storage;
    private final ScheduledExportedExecutorService scheduler;

    public EventInjector(DataSourceFactory factory, Properties properties, int delay, Long loginTimeout) throws SQLException {
        logger.info("Starting event injector");
        this.storage = new JdbcStorageDao(factory, properties, false, loginTimeout, null);
        if (!System.getProperty("org.eclipse.scada.ae.slave.inject.schema", "").trim().isEmpty()) {
            this.storage.setSchema(String.valueOf(System.getProperty("org.eclipse.scada.ae.slave.inject.schema")) + ".");
        }
        this.scheduler = new ScheduledExportedExecutorService("org.eclipse.scada.ae.slave.inject", 1);
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                EventInjector.this.process();
            }
        }, 0L, (long)delay, TimeUnit.MILLISECONDS);
    }

    public void dispose() {
        logger.info("Disposing event injector ...");
        this.scheduler.shutdown();
        this.storage.dispose();
        logger.info("Disposing event injector ... done!");
    }

    private void process() {
        try {
            int result = this.storage.runOnce();
            if (result > 0) {
                logger.info("Processed {} entries", (Object)result);
            } else {
                logger.debug("Processed {} entries", (Object)result);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to process", (Throwable)e);
        }
    }
}

