/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.proxy;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.hd.server.proxy.ProxyItemFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private ExecutorService executor;
    private ProxyItemFactory service;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("HistoricalProxyItem"));
        this.service = new ProxyItemFactory(bundleContext, this.executor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A historical item that proxies access to a set of other items at the same time, merging the result based on the quality.");
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.hd.server.proxy");
        bundleContext.registerService(ConfigurationFactory.class.getName(), (Object)this.service, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.service.dispose();
        this.executor.shutdown();
        context = null;
    }
}

